/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionUtil;

public class DataReaderCommon {
    public static Map<Integer, ?> getIdToConstant(FileScanTask task, Schema projectedSchema, BiFunction<Type, Object, Object> convertConstant) {
        Schema partitionSchema = TypeUtil.select((Schema)projectedSchema, (Set)task.spec().identitySourceIds());
        HashMap<Integer, Object> idToConstant = new HashMap<Integer, Object>();
        if (!partitionSchema.columns().isEmpty()) {
            idToConstant.putAll(PartitionUtil.constantsMap((ContentScanTask)task, convertConstant));
        }
        idToConstant.put(MetadataColumns.FILE_PATH.fieldId(), convertConstant.apply((Type)Types.StringType.get(), ((DataFile)task.file()).path().toString()));
        if (task instanceof MixedFileScanTask) {
            MixedFileScanTask mixedFileScanTask = (MixedFileScanTask)task;
            idToConstant.put(2147482646, convertConstant.apply((Type)Types.LongType.get(), mixedFileScanTask.file().transactionId()));
            idToConstant.put(2147482643, convertConstant.apply((Type)Types.LongType.get(), mixedFileScanTask.file().node().getId()));
            if (mixedFileScanTask.fileType() == DataFileType.BASE_FILE) {
                idToConstant.put(2147482645, convertConstant.apply((Type)Types.LongType.get(), Long.MAX_VALUE));
            }
            if (mixedFileScanTask.fileType() == DataFileType.EQ_DELETE_FILE) {
                idToConstant.put(2147482644, convertConstant.apply((Type)Types.StringType.get(), ChangeAction.DELETE.toString()));
            } else if (mixedFileScanTask.fileType() == DataFileType.INSERT_FILE) {
                idToConstant.put(2147482644, convertConstant.apply((Type)Types.StringType.get(), ChangeAction.INSERT.toString()));
            }
        }
        return idToConstant;
    }

    protected static Map<Integer, ?> getIdToConstant(DataFile dataFile, Schema projectedSchema, PartitionSpec spec, BiFunction<Type, Object, Object> convertConstant) {
        HashMap idToConstant = new HashMap(DataReaderCommon.partitionMap(dataFile, spec, convertConstant));
        idToConstant.put(MetadataColumns.FILE_PATH.fieldId(), convertConstant.apply((Type)Types.StringType.get(), dataFile.path().toString()));
        idToConstant.put(2147482646, convertConstant.apply((Type)Types.LongType.get(), dataFile.dataSequenceNumber()));
        return idToConstant;
    }

    public static Map<Integer, ?> partitionMap(DataFile dataFile, PartitionSpec spec, BiFunction<Type, Object, Object> convertConstant) {
        StructLike partitionData = dataFile.partition();
        HashMap idToConstant = Maps.newHashMap();
        List partitionFields = spec.partitionType().fields();
        List fields = spec.fields();
        for (int pos = 0; pos < fields.size(); ++pos) {
            PartitionField field = (PartitionField)fields.get(pos);
            if (!field.transform().isIdentity()) continue;
            Object converted = convertConstant.apply(((Types.NestedField)partitionFields.get(pos)).type(), partitionData.get(pos, Object.class));
            idToConstant.put(field.sourceId(), converted);
        }
        return idToConstant;
    }
}

