/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.paimon;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.amoro.FormatCatalogFactory;
import org.apache.amoro.TableFormat;
import org.apache.amoro.formats.paimon.PaimonCatalog;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableMetaStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;

public class PaimonCatalogFactory
implements FormatCatalogFactory {
    public static final String PAIMON_S3_ACCESS_KEY = "s3.access-key";
    public static final String PAIMON_S3_SECRET_KEY = "s3.secret-key";

    @Override
    public PaimonCatalog create(String name, String metastoreType, Map<String, String> properties, TableMetaStore metaStore) {
        Optional<URL> hiveSiteLocation = metaStore.getHiveSiteLocation();
        HashMap catalogProperties = Maps.newHashMap();
        catalogProperties.putAll(properties);
        hiveSiteLocation.ifPresent(url -> catalogProperties.put(HiveCatalogOptions.HIVE_CONF_DIR.key(), new File(url.getPath()).getParent()));
        if ("ak/sk".equalsIgnoreCase(metaStore.getAuthMethod())) {
            catalogProperties.put(PAIMON_S3_ACCESS_KEY, metaStore.getAccessKey());
            catalogProperties.put(PAIMON_S3_SECRET_KEY, metaStore.getSecretKey());
            Catalog catalog = PaimonCatalogFactory.paimonCatalog(catalogProperties, new Configuration());
            return new PaimonCatalog(catalog, name);
        }
        Catalog catalog = PaimonCatalogFactory.paimonCatalog(catalogProperties, metaStore.getConfiguration());
        return new PaimonCatalog(catalog, name);
    }

    public static Catalog paimonCatalog(Map<String, String> properties, Configuration configuration) {
        Options options = Options.fromMap(properties);
        CatalogContext catalogContext = CatalogContext.create((Options)options, (Configuration)configuration);
        return CatalogFactory.createCatalog((CatalogContext)catalogContext);
    }

    @Override
    public TableFormat format() {
        return TableFormat.PAIMON;
    }

    @Override
    public Map<String, String> convertCatalogProperties(String catalogName, String metastoreType, Map<String, String> unifiedCatalogProperties) {
        Options options = Options.fromMap(unifiedCatalogProperties);
        String type = "hadoop".equalsIgnoreCase(metastoreType) ? "filesystem" : metastoreType;
        options.set(CatalogOptions.METASTORE, (Object)type);
        return options.toMap();
    }
}

