/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.thrift.org.apache.thrift.transport.sasl;

import java.nio.ByteBuffer;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TEOFException;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransport;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransportException;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.sasl.FrameHeaderReader;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.sasl.TSaslNegotiationException;

public abstract class FrameReader<T extends FrameHeaderReader> {
    private final T header;
    private ByteBuffer payload;

    protected FrameReader(T header) {
        this.header = header;
    }

    public boolean read(TTransport transport) throws TSaslNegotiationException, TTransportException {
        if (!this.header.isComplete()) {
            if (this.readHeader(transport)) {
                this.payload = ByteBuffer.allocate(this.header.payloadSize());
            } else {
                return false;
            }
        }
        if (this.header.payloadSize() == 0) {
            return true;
        }
        return this.readPayload(transport);
    }

    private boolean readHeader(TTransport transport) throws TSaslNegotiationException, TTransportException {
        return this.header.read(transport);
    }

    private boolean readPayload(TTransport transport) throws TTransportException {
        FrameReader.readAvailable(transport, this.payload);
        return this.payload.hasRemaining();
    }

    public T getHeader() {
        return this.header;
    }

    public int getHeaderSize() {
        return this.header.toBytes().length;
    }

    public byte[] getPayload() {
        return this.payload.array();
    }

    public int getPayloadSize() {
        return this.header.payloadSize();
    }

    public boolean isComplete() {
        return this.payload != null && !this.payload.hasRemaining();
    }

    public void clear() {
        this.header.clear();
        this.payload = null;
    }

    static int readAvailable(TTransport transport, ByteBuffer recipient) throws TTransportException {
        int expectedLength;
        int offset;
        if (!recipient.hasRemaining()) {
            throw new IllegalStateException("Trying to fill a full recipient with " + recipient.limit() + " bytes");
        }
        int currentPosition = recipient.position();
        byte[] bytes = recipient.array();
        int got = transport.read(bytes, offset = recipient.arrayOffset() + currentPosition, expectedLength = recipient.remaining());
        if (got < 0) {
            throw new TEOFException("Transport is closed, while trying to read " + expectedLength + " bytes");
        }
        recipient.position(currentPosition + got);
        return got;
    }
}

