/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import org.apache.hadoop.fs.s3a.impl.NetworkBinding;

public final class S3ExpressStorage {
    public static final String STORE_CAPABILITY_S3_EXPRESS_STORAGE = "fs.s3a.capability.s3express.storage";
    public static final String PRODUCT_NAME = "Amazon S3 Express One Zone Storage";
    private static final int SUFFIX_LENGTH = "--usw2-az2--x-s3".length();
    public static final int ZONE_LENGTH = "usw2-az2".length();
    public static final String S3EXPRESS_STORE_SUFFIX = "--x-s3";

    private S3ExpressStorage() {
    }

    public static boolean isS3ExpressStore(String bucket, String endpoint) {
        return NetworkBinding.isAwsEndpoint(endpoint) && S3ExpressStorage.hasS3ExpressSuffix(bucket);
    }

    public static boolean hasS3ExpressSuffix(String bucket) {
        return bucket.endsWith(S3EXPRESS_STORE_SUFFIX);
    }
}

