/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizer.common;

import java.util.Map;
import org.apache.amoro.api.AmoroException;
import org.apache.amoro.api.OptimizerRegisterInfo;
import org.apache.amoro.optimizer.common.AbstractOptimizerOperator;
import org.apache.amoro.optimizer.common.OptimizerConfig;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerToucher
extends AbstractOptimizerOperator {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerToucher.class);
    private TokenChangeListener tokenChangeListener;
    private final Map<String, String> registerProperties = Maps.newHashMap();
    private final long startTime = System.currentTimeMillis();

    public OptimizerToucher(OptimizerConfig config) {
        super(config);
    }

    public OptimizerToucher withTokenChangeListener(TokenChangeListener tokenChangeListener) {
        this.tokenChangeListener = tokenChangeListener;
        return this;
    }

    public OptimizerToucher withRegisterProperty(String name, String value) {
        this.registerProperties.put(name, value);
        LOG.info("Adding register property {}:{} into optimizer", (Object)name, (Object)value);
        return this;
    }

    public void start() {
        LOG.info("Starting optimizer toucher with configuration:{}", (Object)this.getConfig());
        while (this.isStarted()) {
            try {
                if (this.checkToken()) {
                    this.touch();
                }
                this.waitAShortTime(this.getConfig().getHeartBeat());
            }
            catch (Throwable t) {
                LOG.error("Optimizer toucher got an unexpected error", t);
            }
        }
        LOG.info("Optimizer toucher stopped");
    }

    private boolean checkToken() {
        if (!this.tokenIsReady()) {
            try {
                String token = this.callAms(client -> {
                    this.withRegisterProperty("heart-beat-interval", String.valueOf(this.getConfig().getHeartBeat()));
                    OptimizerRegisterInfo registerInfo = new OptimizerRegisterInfo();
                    registerInfo.setThreadCount(this.getConfig().getExecutionParallel());
                    registerInfo.setMemoryMb(this.getConfig().getMemorySize());
                    registerInfo.setGroupName(this.getConfig().getGroupName());
                    registerInfo.setProperties(this.registerProperties);
                    registerInfo.setResourceId(this.getConfig().getResourceId());
                    registerInfo.setStartTime(this.startTime);
                    return client.authenticate(registerInfo);
                });
                this.setToken(token);
                if (this.tokenChangeListener != null) {
                    this.tokenChangeListener.tokenChange(token);
                }
                LOG.info("Registered optimizer to ams with token:{}", (Object)token);
                return true;
            }
            catch (TException e) {
                LOG.error("Register optimizer to ams failed", (Throwable)e);
                if (e instanceof AmoroException && 1004 == ((AmoroException)e).getErrorCode()) {
                    System.exit(1);
                }
                return false;
            }
        }
        return true;
    }

    private void touch() {
        try {
            this.callAms(client -> {
                client.touch(this.getToken());
                return null;
            });
            LOG.debug("Optimizer[{}] touch ams", (Object)this.getToken());
        }
        catch (TException e) {
            if (e instanceof AmoroException && 2006 == ((AmoroException)e).getErrorCode()) {
                this.setToken(null);
                LOG.error("Got authorization error from ams, try to register later", (Throwable)e);
            }
            LOG.error("Touch ams failed", (Throwable)e);
        }
    }

    public static interface TokenChangeListener {
        public void tokenChange(String var1);
    }
}

