/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.glue.IcebergToGlueConverter;
import org.apache.iceberg.aws.s3.S3FileIO;
import org.apache.iceberg.aws.util.RetryDetector;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.utils.ImmutableMap;

class GlueTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(GlueTableOperations.class);
    private static final String GLUE_EXTERNAL_TABLE_TYPE = "EXTERNAL_TABLE";
    private final GlueClient glue;
    private final AwsProperties awsProperties;
    private final String databaseName;
    private final String tableName;
    private final String fullTableName;
    private final String commitLockEntityId;
    private final Map<String, String> tableCatalogProperties;
    private final Object hadoopConf;
    private final LockManager lockManager;
    private FileIO fileIO;
    private static final DynMethods.UnboundMethod SET_VERSION_ID = DynMethods.builder((String)"versionId").hiddenImpl("software.amazon.awssdk.services.glue.model.UpdateTableRequest$Builder", new Class[]{String.class}).orNoop().build();

    GlueTableOperations(GlueClient glue, LockManager lockManager, String catalogName, AwsProperties awsProperties, Map<String, String> tableCatalogProperties, Object hadoopConf, TableIdentifier tableIdentifier) {
        this.glue = glue;
        this.awsProperties = awsProperties;
        this.databaseName = IcebergToGlueConverter.getDatabaseName(tableIdentifier, awsProperties.glueCatalogSkipNameValidation());
        this.tableName = IcebergToGlueConverter.getTableName(tableIdentifier, awsProperties.glueCatalogSkipNameValidation());
        this.fullTableName = String.format("%s.%s.%s", catalogName, this.databaseName, this.tableName);
        this.commitLockEntityId = String.format("%s.%s", this.databaseName, this.tableName);
        this.tableCatalogProperties = tableCatalogProperties;
        this.hadoopConf = hadoopConf;
        this.lockManager = lockManager;
    }

    public FileIO io() {
        if (this.fileIO == null) {
            this.fileIO = GlueTableOperations.initializeFileIO(this.tableCatalogProperties, this.hadoopConf);
        }
        return this.fileIO;
    }

    protected String tableName() {
        return this.fullTableName;
    }

    protected void doRefresh() {
        String metadataLocation = null;
        Table table = this.getGlueTable();
        if (table != null) {
            GlueTableOperations.checkIfTableIsIceberg(table, this.tableName());
            metadataLocation = (String)table.parameters().get("metadata_location");
        } else if (this.currentMetadataLocation() != null) {
            throw new NoSuchTableException("Cannot find Glue table %s after refresh, maybe another process deleted it or revoked your access permission", new Object[]{this.tableName()});
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        BaseMetastoreTableOperations.CommitStatus commitStatus = BaseMetastoreTableOperations.CommitStatus.FAILURE;
        RetryDetector retryDetector = new RetryDetector();
        String newMetadataLocation = null;
        boolean glueTempTableCreated = false;
        try {
            glueTempTableCreated = this.createGlueTempTableIfNecessary(base, metadata.location());
            boolean newTable = base == null;
            newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
            this.lock(newMetadataLocation);
            Table glueTable = this.getGlueTable();
            this.checkMetadataLocation(glueTable, base);
            Map<String, String> properties = this.prepareProperties(glueTable, newMetadataLocation);
            this.persistGlueTable(glueTable, properties, metadata, retryDetector);
            commitStatus = BaseMetastoreTableOperations.CommitStatus.SUCCESS;
        }
        catch (CommitFailedException e) {
            try {
                throw e;
                catch (RuntimeException persistFailure) {
                    boolean isAwsServiceException = persistFailure instanceof AwsServiceException;
                    if (!isAwsServiceException || retryDetector.retried()) {
                        LOG.warn("Received unexpected failure when committing to {}, validating if commit ended up succeeding.", (Object)this.fullTableName, (Object)persistFailure);
                        commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
                    }
                    if (commitStatus != BaseMetastoreTableOperations.CommitStatus.SUCCESS && isAwsServiceException) {
                        this.handleAWSExceptions((AwsServiceException)persistFailure);
                    }
                    switch (commitStatus) {
                        case SUCCESS: {
                            break;
                        }
                        case FAILURE: {
                            throw new CommitFailedException((Throwable)persistFailure, "Cannot commit %s due to unexpected exception", new Object[]{this.tableName()});
                        }
                        case UNKNOWN: {
                            throw new CommitStateUnknownException((Throwable)persistFailure);
                        }
                    }
                    this.cleanupMetadataAndUnlock(commitStatus, newMetadataLocation);
                    this.cleanupGlueTempTableIfNecessary(glueTempTableCreated, commitStatus);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.cleanupMetadataAndUnlock(commitStatus, newMetadataLocation);
                this.cleanupGlueTempTableIfNecessary(glueTempTableCreated, commitStatus);
                throw throwable;
            }
        }
        this.cleanupMetadataAndUnlock(commitStatus, newMetadataLocation);
        this.cleanupGlueTempTableIfNecessary(glueTempTableCreated, commitStatus);
    }

    static void checkIfTableIsIceberg(Table table, String fullName) {
        String tableType = (String)table.parameters().get("table_type");
        NoSuchIcebergTableException.check((tableType != null && tableType.equalsIgnoreCase("iceberg") ? 1 : 0) != 0, (String)"Input Glue table is not an iceberg table: %s (type=%s)", (Object[])new Object[]{fullName, tableType});
    }

    protected static FileIO initializeFileIO(Map<String, String> properties, Object hadoopConf) {
        String fileIOImpl = properties.get("io-impl");
        if (fileIOImpl == null) {
            S3FileIO io = new S3FileIO();
            io.initialize(properties);
            return io;
        }
        return CatalogUtil.loadFileIO((String)fileIOImpl, properties, (Object)hadoopConf);
    }

    private boolean createGlueTempTableIfNecessary(TableMetadata base, String metadataLocation) {
        if (this.awsProperties.glueLakeFormationEnabled() && base == null) {
            this.glue.createTable((CreateTableRequest)CreateTableRequest.builder().databaseName(this.databaseName).tableInput((TableInput)TableInput.builder().parameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg")).name(this.tableName).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().location(metadataLocation).build()).build()).build());
            return true;
        }
        return false;
    }

    private void cleanupGlueTempTableIfNecessary(boolean glueTempTableCreated, BaseMetastoreTableOperations.CommitStatus commitStatus) {
        if (glueTempTableCreated && commitStatus != BaseMetastoreTableOperations.CommitStatus.SUCCESS) {
            this.glue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().databaseName(this.databaseName).name(this.tableName).build());
        }
    }

    private void lock(String newMetadataLocation) {
        if (this.lockManager != null && !this.lockManager.acquire(this.commitLockEntityId, newMetadataLocation)) {
            throw new IllegalStateException(String.format("Fail to acquire lock %s to commit new metadata at %s", this.commitLockEntityId, newMetadataLocation));
        }
    }

    private void checkMetadataLocation(Table glueTable, TableMetadata base) {
        String baseMetadataLocation;
        String glueMetadataLocation = glueTable != null ? (String)glueTable.parameters().get("metadata_location") : null;
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, glueMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s because base metadata location '%s' is not same as the current Glue location '%s'", new Object[]{this.tableName(), baseMetadataLocation, glueMetadataLocation});
        }
    }

    private Table getGlueTable() {
        try {
            GetTableResponse response = this.glue.getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).name(this.tableName).build());
            return response.table();
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    private Map<String, String> prepareProperties(Table glueTable, String newMetadataLocation) {
        HashMap properties = glueTable != null ? Maps.newHashMap((Map)glueTable.parameters()) : Maps.newHashMap();
        properties.put("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        properties.put("metadata_location", newMetadataLocation);
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            properties.put("previous_metadata_location", this.currentMetadataLocation());
        }
        return properties;
    }

    @VisibleForTesting
    void persistGlueTable(Table glueTable, Map<String, String> parameters, TableMetadata metadata, RetryDetector retryDetector) {
        if (glueTable != null) {
            LOG.debug("Committing existing Glue table: {}", (Object)this.tableName());
            UpdateTableRequest.Builder updateTableRequest = UpdateTableRequest.builder().overrideConfiguration(c -> {
                AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)c.addMetricPublisher((MetricPublisher)retryDetector);
            }).catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).skipArchive(Boolean.valueOf(this.awsProperties.glueCatalogSkipArchive())).tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(builder -> IcebergToGlueConverter.setTableInputInformation(builder, metadata))).name(this.tableName).tableType(GLUE_EXTERNAL_TABLE_TYPE).parameters(parameters).build());
            if (!SET_VERSION_ID.isNoop() && this.lockManager == null) {
                SET_VERSION_ID.invoke((Object)updateTableRequest, new Object[]{glueTable.versionId()});
            }
            this.glue.updateTable((UpdateTableRequest)updateTableRequest.build());
        } else {
            LOG.debug("Committing new Glue table: {}", (Object)this.tableName());
            this.glue.createTable((CreateTableRequest)CreateTableRequest.builder().overrideConfiguration(c -> {
                AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)c.addMetricPublisher((MetricPublisher)retryDetector);
            }).catalogId(this.awsProperties.glueCatalogId()).databaseName(this.databaseName).tableInput((TableInput)((TableInput.Builder)TableInput.builder().applyMutation(builder -> IcebergToGlueConverter.setTableInputInformation(builder, metadata))).name(this.tableName).tableType(GLUE_EXTERNAL_TABLE_TYPE).parameters(parameters).build()).build());
        }
    }

    private void handleAWSExceptions(AwsServiceException persistFailure) {
        if (persistFailure instanceof ConcurrentModificationException) {
            throw new CommitFailedException((Throwable)persistFailure, "Cannot commit %s because Glue detected concurrent update", new Object[]{this.tableName()});
        }
        if (persistFailure instanceof AlreadyExistsException) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException((Throwable)persistFailure, "Cannot commit %s because its Glue table already exists when trying to create one", new Object[]{this.tableName()});
        }
        if (persistFailure instanceof EntityNotFoundException) {
            throw new NotFoundException((Throwable)persistFailure, "Cannot commit %s because Glue cannot find the requested entity", new Object[]{this.tableName()});
        }
        if (persistFailure instanceof AccessDeniedException) {
            throw new ForbiddenException((Throwable)persistFailure, "Cannot commit %s because Glue cannot access the requested resources", new Object[]{this.tableName()});
        }
        if (persistFailure instanceof software.amazon.awssdk.services.glue.model.ValidationException) {
            throw new ValidationException((Throwable)persistFailure, "Cannot commit %s because Glue encountered a validation exception while accessing requested resources", new Object[]{this.tableName()});
        }
        int statusCode = persistFailure.statusCode();
        if (statusCode < 500 || statusCode >= 600) {
            throw persistFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanupMetadataAndUnlock(BaseMetastoreTableOperations.CommitStatus commitStatus, String metadataLocation) {
        try {
            if (commitStatus == BaseMetastoreTableOperations.CommitStatus.FAILURE && metadataLocation != null && !metadataLocation.isEmpty()) {
                this.io().deleteFile(metadataLocation);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Failed to cleanup metadata file at {}", (Object)metadataLocation, (Object)e);
        }
        finally {
            if (this.lockManager != null) {
                this.lockManager.release(this.commitLockEntityId, metadataLocation);
            }
        }
    }

    @VisibleForTesting
    Map<String, String> tableCatalogProperties() {
        return this.tableCatalogProperties;
    }
}

