/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHttpVersion {
    TestHttpVersion() {
    }

    @Test
    void testEqualsMajorMinor() {
        Assertions.assertTrue((boolean)HttpVersion.HTTP_0_9.equals(0, 9));
        Assertions.assertTrue((boolean)HttpVersion.HTTP_1_0.equals(1, 0));
        Assertions.assertTrue((boolean)HttpVersion.HTTP_1_1.equals(1, 1));
        Assertions.assertTrue((boolean)HttpVersion.HTTP_2.equals(2, 0));
        Assertions.assertTrue((boolean)HttpVersion.HTTP_2_0.equals(2, 0));
        Assertions.assertFalse((boolean)HttpVersion.HTTP_0_9.equals(2, 0));
    }

    @Test
    void testGet() {
        Assertions.assertEquals((Object)HttpVersion.HTTP_0_9, (Object)HttpVersion.get((int)0, (int)9));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)HttpVersion.get((int)1, (int)0));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)HttpVersion.get((int)1, (int)1));
        Assertions.assertEquals((Object)HttpVersion.HTTP_2_0, (Object)HttpVersion.get((int)2, (int)0));
        Assertions.assertEquals((Object)HttpVersion.HTTP_2, (Object)HttpVersion.get((int)2, (int)0));
        Assertions.assertNotEquals((Object)HttpVersion.HTTP_2_0, (Object)HttpVersion.get((int)2, (int)1));
        Assertions.assertSame((Object)HttpVersion.HTTP_1_0, (Object)HttpVersion.get((int)1, (int)0));
        Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)HttpVersion.get((int)1, (int)1));
        Assertions.assertSame((Object)HttpVersion.HTTP_2_0, (Object)HttpVersion.get((int)2, (int)0));
        Assertions.assertSame((Object)HttpVersion.HTTP_2, (Object)HttpVersion.get((int)2, (int)0));
        Assertions.assertNotSame((Object)HttpVersion.HTTP_2_0, (Object)HttpVersion.get((int)2, (int)1));
        Assertions.assertNotSame((Object)HttpVersion.HTTP_0_9, (Object)HttpVersion.get((int)0, (int)9));
    }

    @Test
    void testHttpVersionInvalidConstructorInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpVersion(-1, -1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpVersion(0, -1));
    }

    @Test
    void testHttpVersionEquality() {
        HttpVersion ver1 = new HttpVersion(1, 1);
        HttpVersion ver2 = new HttpVersion(1, 1);
        Assertions.assertEquals((int)ver1.hashCode(), (int)ver2.hashCode());
        Assertions.assertEquals((Object)ver1, (Object)ver1);
        Assertions.assertEquals((Object)ver1, (Object)ver2);
        Assertions.assertEquals((Object)ver1, (Object)ver1);
        Assertions.assertEquals((Object)ver1, (Object)ver2);
        Assertions.assertNotEquals((Object)ver1, (Object)Float.valueOf(1.1f));
        Assertions.assertEquals((Object)HttpVersion.HTTP_0_9, (Object)new HttpVersion(0, 9));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)new HttpVersion(1, 0));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)new HttpVersion(1, 1));
        Assertions.assertNotEquals((Object)HttpVersion.HTTP_1_0, (Object)new HttpVersion(1, 1));
        Assertions.assertEquals((Object)HttpVersion.HTTP_0_9, (Object)new ProtocolVersion("HTTP", 0, 9));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)new ProtocolVersion("HTTP", 1, 0));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)new ProtocolVersion("HTTP", 1, 1));
        Assertions.assertNotEquals((Object)HttpVersion.HTTP_1_1, (Object)new ProtocolVersion("http", 1, 1));
        Assertions.assertEquals((Object)HttpVersion.HTTP_0_9, (Object)new ProtocolVersion("HTTP", 0, 9));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)new ProtocolVersion("HTTP", 1, 0));
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)new ProtocolVersion("HTTP", 1, 1));
        Assertions.assertNotEquals((Object)HttpVersion.HTTP_1_1, (Object)new ProtocolVersion("http", 1, 1));
    }

    @Test
    void testHttpVersionComparison() {
        Assertions.assertTrue((boolean)HttpVersion.HTTP_0_9.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1));
        Assertions.assertTrue((boolean)HttpVersion.HTTP_0_9.greaterEquals((ProtocolVersion)HttpVersion.HTTP_0_9));
        Assertions.assertFalse((boolean)HttpVersion.HTTP_0_9.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_0));
        Assertions.assertTrue((HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_0_9) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_0));
    }

    @Test
    void testSerialization() throws Exception {
        HttpVersion orig = HttpVersion.HTTP_1_1;
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
            outStream.close();
            byte[] raw = outbuffer.toByteArray();
            ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
            ObjectInputStream inStream = new ObjectInputStream(inBuffer);
            HttpVersion clone = (HttpVersion)inStream.readObject();
            Assertions.assertEquals((Object)orig, (Object)clone);
        }
    }
}

