/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.messaging.AcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAcidWriteMessage
extends AcidWriteMessage {
    @JsonProperty
    private Long txnid;
    @JsonProperty
    private Long writeId;
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private String database;
    @JsonProperty
    private String table;
    @JsonProperty
    private String partition;
    @JsonProperty
    private String tableObjJson;
    @JsonProperty
    private String partitionObjJson;
    @JsonProperty
    private List<String> files;

    public JSONAcidWriteMessage() {
    }

    public JSONAcidWriteMessage(String server, String servicePrincipal, Long timestamp, AcidWriteEvent acidWriteEvent, Iterator<String> files) {
        this.timestamp = timestamp;
        this.txnid = acidWriteEvent.getTxnId();
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.database = acidWriteEvent.getDatabase();
        this.table = acidWriteEvent.getTable();
        this.writeId = acidWriteEvent.getWriteId();
        this.partition = acidWriteEvent.getPartition();
        try {
            this.tableObjJson = MessageBuilder.createTableObjJson(acidWriteEvent.getTableObj());
            this.partitionObjJson = acidWriteEvent.getPartitionObj() != null ? MessageBuilder.createPartitionObjJson(acidWriteEvent.getPartitionObj()) : null;
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize JSONAcidWriteMessage : ", e);
        }
        this.files = Lists.newArrayList(files);
    }

    @Override
    public Long getTxnId() {
        return this.txnid;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getDB() {
        return this.database;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Long getWriteId() {
        return this.writeId;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public Table getTableObj() throws Exception {
        return this.tableObjJson == null ? null : (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Partition getPartitionObj() throws Exception {
        return this.partitionObjJson == null ? null : (Partition)MessageBuilder.getTObj(this.partitionObjJson, Partition.class);
    }

    @Override
    public String getTableObjStr() {
        return this.tableObjJson;
    }

    @Override
    public String getPartitionObjStr() {
        return this.partitionObjJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

