/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampColumnStatsMerger
extends ColumnStatsMerger<Timestamp> {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Timestamp highValue;
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        TimestampColumnStatsDataInspector aggregateData = ColumnsStatsUtils.timestampInspectorFromStats(aggregateColStats);
        TimestampColumnStatsDataInspector newData = ColumnsStatsUtils.timestampInspectorFromStats(newColStats);
        Timestamp lowValue = this.mergeLowValue(this.getLowValue(aggregateData), this.getLowValue(newData));
        if (lowValue != null) {
            aggregateData.setLowValue(lowValue);
        }
        if ((highValue = this.mergeHighValue(this.getHighValue(aggregateData), this.getHighValue(newData))) != null) {
            aggregateData.setHighValue(highValue);
        }
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        KllHistogramEstimator oldKllEst = aggregateData.getHistogramEstimator();
        KllHistogramEstimator newKllEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), oldKllEst, newKllEst));
        aggregateColStats.getStatsData().setTimestampStats((TimestampColumnStatsData)aggregateData);
    }

    public Timestamp getLowValue(TimestampColumnStatsDataInspector data) {
        return data.isSetLowValue() ? data.getLowValue() : null;
    }

    public Timestamp getHighValue(TimestampColumnStatsDataInspector data) {
        return data.isSetHighValue() ? data.getHighValue() : null;
    }

    @Override
    public Timestamp mergeLowValue(Timestamp oldValue, Timestamp newValue) {
        if (oldValue != null && newValue != null) {
            return (Timestamp)ObjectUtils.min((Comparable[])new Timestamp[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Timestamp)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }

    @Override
    public Timestamp mergeHighValue(Timestamp oldValue, Timestamp newValue) {
        if (oldValue != null && newValue != null) {
            return (Timestamp)ObjectUtils.max((Comparable[])new Timestamp[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Timestamp)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }
}

