/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import java.util.Objects;
import org.apache.hadoop.hive.ql.wm.CounterLimit;
import org.apache.hadoop.hive.ql.wm.Expression;

public class TriggerExpression
implements Expression {
    private CounterLimit counterLimit;
    private Expression.Predicate predicate;

    public TriggerExpression(CounterLimit counter, Expression.Predicate predicate) {
        this.counterLimit = counter;
        this.predicate = predicate;
    }

    @Override
    public boolean evaluate(long current) {
        if (this.counterLimit.getLimit() > 0L && this.predicate.equals((Object)Expression.Predicate.GREATER_THAN)) {
            return current > this.counterLimit.getLimit();
        }
        return false;
    }

    @Override
    public CounterLimit getCounterLimit() {
        return this.counterLimit;
    }

    @Override
    public Expression.Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public Expression clone() {
        return new TriggerExpression(this.counterLimit.clone(), this.predicate);
    }

    public String toString() {
        return this.counterLimit.getName() + " " + this.predicate.getSymbol() + " " + this.counterLimit.getLimit();
    }

    public int hashCode() {
        int hash = this.counterLimit == null ? 31 : 31 * this.counterLimit.hashCode();
        return 31 * (hash += this.predicate == null ? 31 * hash : 31 * hash * this.predicate.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof TriggerExpression)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return Objects.equals(this.counterLimit, ((TriggerExpression)other).counterLimit) && Objects.equals((Object)this.predicate, (Object)((TriggerExpression)other).predicate);
    }
}

