/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.service;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactionService {
    private static final String CLASS_NAME = CompactionService.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected IMetaStoreClient msc;
    protected HiveConf conf;
    protected CompactorFactory compactorFactory;
    protected boolean collectGenericStats;
    protected boolean computeStats = false;

    public CompactionService(HiveConf conf, IMetaStoreClient msc, CompactorFactory compactorFactory, boolean collectGenericStats) {
        this.init(conf, msc, compactorFactory, collectGenericStats);
    }

    public CompactionService() {
    }

    public void init(HiveConf conf, IMetaStoreClient msc, CompactorFactory compactorFactory, boolean collectGenericStats) {
        this.conf = conf;
        this.msc = msc;
        this.compactorFactory = compactorFactory;
        this.collectGenericStats = collectGenericStats;
    }

    public abstract Boolean compact(Table var1, CompactionInfo var2) throws Exception;

    public abstract void cleanupResultDirs(CompactionInfo var1);

    public boolean computeStats() {
        return this.computeStats;
    }

    protected boolean isDynPartAbort(Table t, CompactionInfo ci) {
        return t.getPartitionKeys() != null && t.getPartitionKeys().size() > 0 && ci.partName == null;
    }

    protected void failCompactionIfSetForTest() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION)) {
            throw new RuntimeException(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION.name() + "=true");
        }
    }

    protected boolean isTableSorted(StorageDescriptor sd, CompactionInfo ci) throws TException {
        if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
            ci.errorMessage = "Attempt to compact sorted table " + ci.getFullTableName() + ", which is not yet supported!";
            LOG.warn(ci.errorMessage + " Compaction info: {}", (Object)ci);
            this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
            return true;
        }
        return false;
    }
}

