/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;

public abstract class Partish {
    public static Partish buildFor(Table table) {
        return new PTable(table);
    }

    public static Partish buildFor(Partition part) {
        return new PPart(part.getTable(), part);
    }

    public static Partish buildFor(Table table, Partition part) {
        return new PPart(table, part);
    }

    @Deprecated
    public final boolean isAcid() {
        return AcidUtils.isFullAcidTable(this.getTable());
    }

    public final boolean isTransactionalTable() {
        return AcidUtils.isTransactionalTable(this.getTable());
    }

    public abstract Table getTable();

    public abstract Map<String, String> getPartParameters();

    public abstract StorageDescriptor getPartSd();

    public abstract Object getOutput() throws HiveException;

    public abstract Partition getPartition();

    public abstract Class<? extends InputFormat> getInputFormatClass() throws HiveException;

    public abstract Class<? extends OutputFormat> getOutputFormatClass() throws HiveException;

    public abstract String getLocation();

    public abstract String getSimpleName();

    public final String getPartishType() {
        return this.getClass().getSimpleName();
    }

    public abstract Path getPath();

    static class PTable
    extends Partish {
        private Table table;

        public PTable(Table table) {
            this.table = table;
        }

        @Override
        public Table getTable() {
            return this.table;
        }

        @Override
        public Map<String, String> getPartParameters() {
            return this.table.getTTable().getParameters();
        }

        @Override
        public StorageDescriptor getPartSd() {
            return this.table.getTTable().getSd();
        }

        @Override
        public Object getOutput() throws HiveException {
            return new Table(this.getTable().getTTable());
        }

        @Override
        public Partition getPartition() {
            return null;
        }

        @Override
        public Class<? extends InputFormat> getInputFormatClass() {
            return this.table.getInputFormatClass();
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass() {
            return this.table.getOutputFormatClass();
        }

        @Override
        public String getLocation() {
            return this.table.getDataLocation().toString();
        }

        @Override
        public String getSimpleName() {
            return String.format("Table %s.%s", this.table.getDbName(), this.table.getTableName());
        }

        @Override
        public Path getPath() {
            return this.table.getPath();
        }
    }

    static class PPart
    extends Partish {
        private Table table;
        private Partition partition;

        public PPart(Table table, Partition partition) {
            this.table = table;
            this.partition = partition;
        }

        @Override
        public Table getTable() {
            return this.table;
        }

        @Override
        public Map<String, String> getPartParameters() {
            return this.partition.getTPartition().getParameters();
        }

        @Override
        public StorageDescriptor getPartSd() {
            return this.partition.getTPartition().getSd();
        }

        @Override
        public Object getOutput() throws HiveException {
            return new Partition(this.table, this.partition.getTPartition());
        }

        @Override
        public Partition getPartition() {
            return this.partition;
        }

        @Override
        public Class<? extends InputFormat> getInputFormatClass() throws HiveException {
            return this.partition.getInputFormatClass();
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass() throws HiveException {
            return this.partition.getOutputFormatClass();
        }

        @Override
        public String getLocation() {
            return this.partition.getLocation();
        }

        @Override
        public String getSimpleName() {
            return String.format("Partition %s.%s %s", this.table.getDbName(), this.table.getTableName(), this.partition.getSpec());
        }

        @Override
        public Path getPath() {
            return this.partition.getPartitionPath();
        }
    }
}

