/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.TransformSpec;

public class PartitionTransform {
    private static final Map<Integer, TransformSpec.TransformType> TRANSFORMS = Stream.of({1053, TransformSpec.TransformType.IDENTITY}, {1332, TransformSpec.TransformType.YEAR}, {1097, TransformSpec.TransformType.MONTH}, {984, TransformSpec.TransformType.DAY}, {1052, TransformSpec.TransformType.HOUR}, {1296, TransformSpec.TransformType.TRUNCATE}, {938, TransformSpec.TransformType.BUCKET}).collect(Collectors.toMap(e -> (Integer)e[0], e -> (TransformSpec.TransformType)((Object)((Object)e[1]))));

    public static List<TransformSpec> getPartitionTransformSpec(List<FieldSchema> fields) {
        return fields.stream().map(field -> new TransformSpec(field.getName(), TransformSpec.TransformType.IDENTITY, null)).collect(Collectors.toList());
    }

    public static List<TransformSpec> getPartitionTransformSpec(ASTNode node) {
        ArrayList<TransformSpec> partSpecList = new ArrayList<TransformSpec>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            TransformSpec spec = new TransformSpec();
            ASTNode child = (ASTNode)node.getChild(i);
            block5: for (int j = 0; j < child.getChildCount(); ++j) {
                ASTNode grandChild = (ASTNode)child.getChild(j);
                switch (grandChild.getToken().getType()) {
                    case 984: 
                    case 1052: 
                    case 1053: 
                    case 1097: 
                    case 1332: {
                        spec.setColumnName(grandChild.getChild(0).getText().toLowerCase());
                        spec.setTransformType(TRANSFORMS.get(grandChild.getToken().getType()));
                        continue block5;
                    }
                    case 938: 
                    case 1296: {
                        spec.setTransformType(TRANSFORMS.get(grandChild.getToken().getType()));
                        spec.setTransformParam(Integer.valueOf(grandChild.getChild(0).getText()));
                        spec.setColumnName(grandChild.getChild(1).getText().toLowerCase());
                    }
                }
            }
            partSpecList.add(spec);
        }
        return partSpecList;
    }
}

