/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.alter;

import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.catalog.alter.AbstractAlterCatalogDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class AbstractAlterCatalogOperation<T extends AbstractAlterCatalogDesc>
extends DDLOperation<T> {
    public AbstractAlterCatalogOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        String catalogName = ((AbstractAlterCatalogDesc)this.desc).getCatalogName();
        Catalog catalog = this.context.getDb().getMSC().getCatalog(catalogName);
        if (catalog == null) {
            throw new HiveException(ErrorMsg.CATALOG_NOT_EXISTS, new String[]{catalogName});
        }
        this.doAlteration(catalog);
        this.context.getDb().alterCatalog(catalogName, catalog);
        return 0;
    }

    protected abstract void doAlteration(Catalog var1) throws HiveException;
}

