/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergDeleteOrphanFiles
implements DeleteOrphanFiles {
    public static final String METADATA_FOLDER_NAME = "metadata";
    public static final String DATA_FOLDER_NAME = "data";
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergDeleteOrphanFiles.class);
    private String tableLocation;
    private long olderThanTimestamp = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(3L);
    private Consumer<String> deleteFunc;
    private ExecutorService deleteExecutorService = MoreExecutors.newDirectExecutorService();
    private final Configuration conf;
    private final Table table;

    public HiveIcebergDeleteOrphanFiles(Configuration conf, Table table) {
        this.conf = conf;
        this.table = table;
        this.deleteFunc = file -> table.io().deleteFile((String)file);
        this.tableLocation = table.location();
    }

    @Override
    public HiveIcebergDeleteOrphanFiles location(String location) {
        this.tableLocation = location;
        return this;
    }

    @Override
    public HiveIcebergDeleteOrphanFiles olderThan(long newOlderThanTimestamp) {
        this.olderThanTimestamp = newOlderThanTimestamp;
        return this;
    }

    @Override
    public HiveIcebergDeleteOrphanFiles deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    @Override
    public HiveIcebergDeleteOrphanFiles executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    @Override
    public DeleteOrphanFiles.Result execute() {
        LOG.info("Cleaning orphan files for {}", (Object)this.table.name());
        HiveIcebergDeleteOrphanFilesResult result = new HiveIcebergDeleteOrphanFilesResult();
        result.addDeletedFiles(this.cleanContentFiles(this.olderThanTimestamp));
        result.addDeletedFiles(this.cleanMetadata(this.olderThanTimestamp));
        LOG.debug("Deleting {} files while cleaning orphan files for {}", (Object)result.deletedFiles.size(), (Object)this.table.name());
        Tasks.foreach(result.deletedFiles).executeWith(this.deleteExecutorService).retry(3).stopRetryOn(FileNotFoundException.class).suppressFailureWhenFinished().onFailure((file, thrown) -> LOG.warn("Delete failed for file: {}", file, (Object)thrown)).run(this.deleteFunc::accept);
        return result;
    }

    private Set<String> cleanContentFiles(long lastTime) {
        Sets.SetView<String> validFiles = Sets.union(this.getAllContentFilePath(), HiveIcebergDeleteOrphanFiles.getAllStatisticsFilePath(this.table));
        LOG.debug("Valid content file for {} are {}", (Object)this.table.name(), (Object)validFiles.size());
        try {
            Path dataPath = new Path(this.tableLocation, DATA_FOLDER_NAME);
            return this.getFilesToBeDeleted(lastTime, validFiles, dataPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Set<String> getAllContentFilePath() {
        HashSet<String> validFilesPath = Sets.newHashSet();
        Table metadatTable = this.getMetadataTable();
        TableScan tableScan = metadatTable.newScan();
        CloseableIterable<FileScanTask> manifestFileScanTasks = tableScan.planFiles();
        CloseableIterable<StructLike> entries = CloseableIterable.concat(this.entriesOfManifest(manifestFileScanTasks));
        for (StructLike entry : entries) {
            StructLike fileRecord = entry.get(4, StructLike.class);
            String filePath = fileRecord.get(1, String.class);
            validFilesPath.add(HiveIcebergDeleteOrphanFiles.getUriPath(filePath));
        }
        return validFilesPath;
    }

    private Iterable<CloseableIterable<StructLike>> entriesOfManifest(CloseableIterable<FileScanTask> fileScanTasks) {
        return Iterables.transform(fileScanTasks, task -> {
            assert (task != null);
            return ((DataTask)task).rows();
        });
    }

    public static Set<String> getAllStatisticsFilePath(Table table) {
        return ReachableFileUtil.statisticsFilesLocations(table).stream().map(HiveIcebergDeleteOrphanFiles::getUriPath).collect(Collectors.toSet());
    }

    protected Set<String> cleanMetadata(long lastTime) {
        LOG.info("{} start clean metadata files", (Object)this.table.name());
        try {
            Set<String> validFiles = HiveIcebergDeleteOrphanFiles.getValidMetadataFiles(this.table);
            LOG.debug("Valid metadata files for {} are {}", (Object)this.table.name(), validFiles);
            Path metadataLocation = new Path(this.tableLocation, METADATA_FOLDER_NAME);
            return this.getFilesToBeDeleted(lastTime, validFiles, metadataLocation);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private Set<String> getFilesToBeDeleted(long lastTime, Set<String> validFiles, Path location) throws IOException {
        HashSet<String> filesToDelete = Sets.newHashSet();
        FileSystem fs = location.getFileSystem(this.conf);
        RemoteIterator metadataLocations = fs.listFiles(location, true);
        while (metadataLocations.hasNext()) {
            LocatedFileStatus metadataFile = (LocatedFileStatus)metadataLocations.next();
            if (metadataFile.getModificationTime() >= lastTime || validFiles.contains(HiveIcebergDeleteOrphanFiles.getUriPath(metadataFile.getPath().toString()))) continue;
            filesToDelete.add(metadataFile.getPath().toString());
        }
        return filesToDelete;
    }

    private Table getMetadataTable() {
        return MetadataTableUtils.createMetadataTableInstance(((HasTableOperations)((Object)this.table)).operations(), this.table.name(), this.table.name() + "#" + MetadataTableType.ALL_ENTRIES.name(), MetadataTableType.ALL_ENTRIES);
    }

    private static Set<String> getValidMetadataFiles(Table icebergTable) {
        HashSet<String> validFiles = Sets.newHashSet();
        Iterable<Snapshot> snapshots = icebergTable.snapshots();
        for (Snapshot snapshot : snapshots) {
            String manifestListLocation = snapshot.manifestListLocation();
            validFiles.add(HiveIcebergDeleteOrphanFiles.getUriPath(manifestListLocation));
            List<ManifestFile> manifestFiles = snapshot.allManifests(icebergTable.io());
            for (ManifestFile manifestFile : manifestFiles) {
                validFiles.add(HiveIcebergDeleteOrphanFiles.getUriPath(manifestFile.path()));
            }
        }
        Stream.of(ReachableFileUtil.metadataFileLocations(icebergTable, false).stream(), ReachableFileUtil.statisticsFilesLocations(icebergTable).stream(), Stream.of(ReachableFileUtil.versionHintLocation(icebergTable))).reduce(Stream::concat).orElse(Stream.empty()).map(HiveIcebergDeleteOrphanFiles::getUriPath).forEach(validFiles::add);
        return validFiles;
    }

    private static String getUriPath(String path) {
        return URI.create(path).getPath();
    }

    static class HiveIcebergDeleteOrphanFilesResult
    implements DeleteOrphanFiles.Result {
        private final Set<String> deletedFiles = Sets.newHashSet();

        HiveIcebergDeleteOrphanFilesResult() {
        }

        @Override
        public Iterable<String> orphanFileLocations() {
            return this.deletedFiles;
        }

        public void addDeletedFiles(Set<String> files) {
            this.deletedFiles.addAll(files);
        }
    }
}

