/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.jsonexplain.Connection;
import org.apache.hadoop.hive.common.jsonexplain.DagJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.Op;
import org.apache.hadoop.hive.common.jsonexplain.Printer;
import org.apache.hadoop.hive.common.jsonexplain.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Vertex
implements Comparable<Vertex> {
    public final String name;
    public final Stage stage;
    public final DagJsonParser parser;
    public final List<Connection> parentConnections = new ArrayList<Connection>();
    public final List<Vertex> children = new ArrayList<Vertex>();
    public final JSONObject vertexObject;
    public boolean dummy;
    public final List<Op> outputOps = new ArrayList<Op>();
    public final List<Op> inputOps = new ArrayList<Op>();
    public final List<Vertex> mergeJoinDummyVertices = new ArrayList<Vertex>();
    public int numReduceOp = 0;
    public String executionMode = "";
    public Map<String, String> tagToInput = new LinkedHashMap<String, String>();
    public String tag;
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    public VertexType vertexType;
    public String edgeType;

    public Vertex(String name, JSONObject vertexObject, Stage stage, DagJsonParser dagJsonParser) {
        this.name = name;
        this.vertexType = this.name != null ? (this.name.contains("Map") ? VertexType.MAP : (this.name.contains("Reduce") ? VertexType.REDUCE : (this.name.contains("Union") ? VertexType.UNION : VertexType.UNKNOWN))) : VertexType.UNKNOWN;
        this.dummy = false;
        this.vertexObject = vertexObject;
        this.stage = stage;
        this.parser = dagJsonParser;
    }

    public void addDependency(Connection connection) throws JSONException {
        this.parentConnections.add(connection);
    }

    public void extractOpTree() throws Exception {
        if (this.vertexObject.length() != 0) {
            for (String key : JSONObject.getNames((JSONObject)this.vertexObject)) {
                if (key.equals("Map Operator Tree:")) {
                    this.extractOp(this.vertexObject.getJSONArray(key).getJSONObject(0), null);
                    continue;
                }
                if (key.equals("Reduce Operator Tree:") || key.equals("Processor Tree:")) {
                    this.extractOp(this.vertexObject.getJSONObject(key), null);
                    continue;
                }
                if (key.equals("Join:")) {
                    JSONArray array = this.vertexObject.getJSONArray(key);
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject mpOpTree = array.getJSONObject(index);
                        Vertex v = new Vertex(null, mpOpTree, this.stage, this.parser);
                        v.extractOpTree();
                        v.dummy = true;
                        this.mergeJoinDummyVertices.add(v);
                    }
                    continue;
                }
                if (key.equals("Merge File Operator")) {
                    JSONObject opTree = this.vertexObject.getJSONObject(key);
                    if (opTree.has("Map Operator Tree:")) {
                        this.extractOp(opTree.getJSONArray("Map Operator Tree:").getJSONObject(0), null);
                        continue;
                    }
                    throw new Exception("Merge File Operator does not have a Map Operator Tree");
                }
                if (key.equals("Execution mode:")) {
                    this.executionMode = " " + this.vertexObject.getString(key);
                    continue;
                }
                if (key.equals("tagToInput:")) {
                    JSONObject tagToInput = this.vertexObject.getJSONObject(key);
                    for (String tag : JSONObject.getNames((JSONObject)tagToInput)) {
                        this.tagToInput.put(tag, (String)tagToInput.get(tag));
                    }
                    continue;
                }
                if (key.equals("tag:")) {
                    this.tag = this.vertexObject.getString(key);
                    continue;
                }
                if (key.equals("Local Work:")) {
                    this.extractOp(this.vertexObject.getJSONObject(key), null);
                    continue;
                }
                this.LOG.warn("Skip unsupported " + key + " in vertex " + this.name);
            }
        }
    }

    Op extractOp(JSONObject object, Op parent) throws Exception {
        String[] names = JSONObject.getNames((JSONObject)object);
        if (names.length != 1) {
            throw new Exception("Expect only one operator in " + object.toString());
        }
        String opName = names[0];
        JSONObject attrObj = (JSONObject)object.get(opName);
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        ArrayList<Op> children = new ArrayList<Op>();
        Op op = new Op(opName, null, null, parent, children, attrs, attrObj, this, this.parser);
        if (JSONObject.getNames((JSONObject)attrObj) != null) {
            for (String attrName : JSONObject.getNames((JSONObject)attrObj)) {
                if (attrName.equals("children")) {
                    Object childrenObj = attrObj.get(attrName);
                    if (childrenObj instanceof JSONObject) {
                        JSONObject nObject = (JSONObject)childrenObj;
                        if (nObject.length() == 0) continue;
                        children.add(this.extractOp(nObject, op));
                        continue;
                    }
                    if (childrenObj instanceof JSONArray) {
                        JSONArray nArray = (JSONArray)childrenObj;
                        if (nArray.length() == 0) continue;
                        for (int index = 0; index < nArray.length(); ++index) {
                            children.add(this.extractOp(nArray.getJSONObject(index), op));
                        }
                        continue;
                    }
                    throw new Exception("Unsupported operator " + this.name + "'s children operator is neither a jsonobject nor a jsonarray");
                }
                if (attrName.equals("OperatorId:")) {
                    op.setOperatorId(attrObj.get(attrName).toString());
                    continue;
                }
                if (attrName.equals("outputname:")) {
                    op.outputVertexName = attrObj.get(attrName).toString();
                    continue;
                }
                if (attrObj.get(attrName).toString().isEmpty()) continue;
                attrs.put(attrName, attrObj.get(attrName).toString());
            }
        }
        if (parent == null) {
            this.inputOps.add(op);
        }
        if (children.isEmpty()) {
            this.outputOps.add(op);
        }
        return op;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void print(Printer printer, int indentFlag, String type, Vertex callingVertex) throws Exception {
        if (this.parser.printSet.contains(this) && this.numReduceOp <= 1) {
            if (type != null) {
                printer.println(DagJsonParser.prefixString(indentFlag, "<-") + " Please refer to the previous " + this.name + " [" + type + "]");
                return;
            } else {
                printer.println(DagJsonParser.prefixString(indentFlag, "<-") + " Please refer to the previous " + this.name);
            }
            return;
        }
        this.parser.printSet.add(this);
        if (type != null) {
            printer.println(DagJsonParser.prefixString(indentFlag, "<-") + this.name + " [" + type + "]" + this.executionMode);
        } else if (this.name != null) {
            printer.println(DagJsonParser.prefixString(indentFlag) + this.name + this.executionMode);
        }
        if (this.numReduceOp > 1 && callingVertex.vertexType != VertexType.UNION) {
            Object choose = null;
            for (Op op : this.outputOps) {
                if (!callingVertex.name.equals(op.outputVertexName)) continue;
                choose = op;
            }
            if (choose == null) throw new Exception("Can not find the right reduce output operator for vertex " + this.name);
            ((Op)choose).print(printer, indentFlag, false);
        } else {
            for (Op op : this.outputOps) {
                if (this.dummy) {
                    op.print(printer, indentFlag, true);
                    continue;
                }
                op.print(printer, indentFlag, false);
            }
        }
        if (this.vertexType != VertexType.UNION) return;
        ++indentFlag;
        for (int index = 0; index < this.parentConnections.size(); ++index) {
            Connection connection = this.parentConnections.get(index);
            connection.from.print(printer, indentFlag, connection.type, this);
        }
    }

    public void checkMultiReduceOperator(boolean rewriteObject) throws JSONException {
        this.numReduceOp = 0;
        for (Op op : this.outputOps) {
            Vertex outputVertex;
            if (op.type != Op.OpType.RS) continue;
            if (rewriteObject && (outputVertex = this.stage.vertices.get(op.outputVertexName)) != null && outputVertex.inputOps.size() > 0) {
                JSONArray array = new JSONArray();
                for (Op inputOp : outputVertex.inputOps) {
                    array.put((Object)inputOp.operatorId);
                }
                op.opObject.put("outputOperator:", (Object)array);
            }
            ++this.numReduceOp;
        }
    }

    public void setType(String type) {
        this.edgeType = this.parser.mapEdgeType(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return Objects.equals(this.name, vertex.name) && Objects.equals(this.stage, vertex.stage) && Objects.equals(this.vertexObject, vertex.vertexObject);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.stage, this.vertexObject);
    }

    @Override
    public int compareTo(Vertex o) {
        if (this.numReduceOp != o.numReduceOp) {
            return -(this.numReduceOp - o.numReduceOp);
        }
        return this.name.compareTo(o.name);
    }

    public Op getJoinRSOp(Vertex joinVertex) {
        if (this.outputOps.size() == 0) {
            return null;
        }
        if (this.outputOps.size() == 1) {
            if (this.outputOps.get((int)0).type == Op.OpType.RS) {
                return this.outputOps.get(0);
            }
            return null;
        }
        for (Op op : this.outputOps) {
            if (op.type != Op.OpType.RS || !op.outputVertexName.equals(joinVertex.name)) continue;
            return op;
        }
        return null;
    }

    public static enum VertexType {
        MAP,
        REDUCE,
        UNION,
        UNKNOWN;

    }

    public static enum EdgeType {
        BROADCAST,
        SHUFFLE,
        MULTICAST,
        PARTITION_ONLY_SHUFFLE,
        FORWARD,
        XPROD_EDGE,
        UNKNOWN;

    }
}

