/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.util.BloomFilter;
import org.apache.orc.util.BloomFilterIO;

public class CheckTool {
    private static final String CHECK_TYPE_PREDICATE = "predicate";
    private static final String CHECK_TYPE_STAT = "stat";
    private static final String CHECK_TYPE_BLOOM_FILTER = "bloom-filter";

    public static void main(Configuration conf, String[] args) throws Exception {
        Options opts = CheckTool.createOptions();
        CommandLine cli = new DefaultParser().parse(opts, args);
        HelpFormatter formatter = new HelpFormatter();
        if (cli.hasOption('h')) {
            formatter.printHelp("check", opts);
            return;
        }
        String type = cli.getOptionValue("type");
        if (type == null || !type.equals(CHECK_TYPE_PREDICATE) && !type.equals(CHECK_TYPE_STAT) && !type.equals(CHECK_TYPE_BLOOM_FILTER)) {
            System.err.printf("type %s not support %n", type);
            formatter.printHelp("check", opts);
            return;
        }
        String column = cli.getOptionValue("column");
        if (column == null || column.isEmpty()) {
            System.err.println("column is null");
            formatter.printHelp("check", opts);
            return;
        }
        String[] values = cli.getOptionValues("values");
        if (values == null || values.length == 0) {
            System.err.println("values is null");
            formatter.printHelp("check", opts);
            return;
        }
        boolean ignoreExtension = cli.hasOption("ignoreExtension");
        ArrayList<Path> inputFiles = new ArrayList<Path>();
        String[] files = cli.getArgs();
        for (String root : files) {
            Path rootPath = new Path(root);
            FileSystem fs = rootPath.getFileSystem(conf);
            RemoteIterator itr = fs.listFiles(rootPath, true);
            while (itr.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)itr.next();
                if (!status.isFile() || !ignoreExtension && !status.getPath().getName().endsWith(".orc")) continue;
                inputFiles.add(status.getPath());
            }
        }
        if (inputFiles.isEmpty()) {
            System.err.println("No files found.");
            System.exit(1);
        }
        for (Path inputFile : inputFiles) {
            System.out.println("input file: " + String.valueOf(inputFile));
            FileSystem fs = inputFile.getFileSystem(conf);
            Reader reader = OrcFile.createReader((Path)inputFile, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).filesystem(fs));
            try {
                RecordReaderImpl rows = (RecordReaderImpl)reader.rows();
                TypeDescription schema = reader.getSchema();
                boolean[] includedColumns = OrcUtils.includeColumns((String)column, (TypeDescription)schema);
                int colIndex = -1;
                for (int i = 0; i < includedColumns.length; ++i) {
                    if (!includedColumns[i]) continue;
                    colIndex = i;
                    break;
                }
                if (colIndex == -1) {
                    System.err.printf("column: %s not found in file: %s%n", column, inputFile);
                    continue;
                }
                int stripeIndex = -1;
                for (StripeInformation stripe : reader.getStripes()) {
                    OrcProto.StripeFooter footer = rows.readStripeFooter(stripe);
                    OrcProto.ColumnEncoding columnEncoding = footer.getColumns(colIndex);
                    TypeDescription subtype = reader.getSchema().findSubtype(colIndex);
                    TypeDescription.Category columnCategory = subtype.getCategory();
                    OrcIndex indices = rows.readRowIndex(++stripeIndex, null, includedColumns);
                    if (type.equals(CHECK_TYPE_BLOOM_FILTER)) {
                        CheckTool.checkBloomFilter(inputFile, reader, indices, stripeIndex, colIndex, column, columnEncoding, columnCategory, values);
                        continue;
                    }
                    CheckTool.checkStatOrPredicate(inputFile, reader, indices, stripeIndex, colIndex, column, columnEncoding, subtype, columnCategory, values, type);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    private static void checkStatOrPredicate(Path inputFile, Reader reader, OrcIndex indices, int stripeIndex, int colIndex, String column, OrcProto.ColumnEncoding columnEncoding, TypeDescription subtype, TypeDescription.Category columnCategory, String[] values, String type) {
        OrcProto.RowIndex rowGroupIndex = indices.getRowGroupIndex()[colIndex];
        int entryCount = rowGroupIndex.getEntryCount();
        boolean hasBloomFilter = true;
        OrcProto.BloomFilterIndex[] bloomFilterIndices = indices.getBloomFilterIndex();
        OrcProto.BloomFilterIndex bloomFilterIndex = bloomFilterIndices[colIndex];
        if (bloomFilterIndex == null || bloomFilterIndex.getBloomFilterList().isEmpty()) {
            hasBloomFilter = false;
        }
        for (int i = 0; i < entryCount; ++i) {
            OrcProto.ColumnStatistics statistics = rowGroupIndex.getEntry(i).getStatistics();
            ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((TypeDescription)subtype, (OrcProto.ColumnStatistics)statistics, (boolean)reader.writerUsedProlepticGregorian(), (boolean)reader.getConvertToProlepticGregorian());
            BloomFilter bloomFilter = null;
            if (type.equals(CHECK_TYPE_PREDICATE) && hasBloomFilter) {
                bloomFilter = BloomFilterIO.deserialize((OrcProto.Stream.Kind)indices.getBloomFilterKinds()[colIndex], (OrcProto.ColumnEncoding)columnEncoding, (OrcFile.WriterVersion)reader.getWriterVersion(), (TypeDescription.Category)columnCategory, (OrcProto.BloomFilter)bloomFilterIndex.getBloomFilter(i));
            }
            for (String value : values) {
                PredicateLeaf predicateLeaf = CheckTool.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, CheckTool.getPredicateLeafType(columnCategory), column, CheckTool.convert(columnCategory, value));
                SearchArgument.TruthValue truthValue = RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)predicateLeaf, (BloomFilter)bloomFilter);
                System.out.printf("stripe: %d, rowIndex: %d, value: %s, test value: %s%n", stripeIndex, i, value, truthValue);
            }
        }
    }

    private static void checkBloomFilter(Path inputFile, Reader reader, OrcIndex indices, int stripeIndex, int colIndex, String column, OrcProto.ColumnEncoding columnEncoding, TypeDescription.Category columnCategory, String[] values) {
        OrcProto.BloomFilterIndex[] bloomFilterIndices = indices.getBloomFilterIndex();
        OrcProto.BloomFilterIndex bloomFilterIndex = bloomFilterIndices[colIndex];
        if (bloomFilterIndex == null || bloomFilterIndex.getBloomFilterList().isEmpty()) {
            System.err.printf("The bloom filter index for column: %s is not found in file: %s%n", column, inputFile);
            return;
        }
        List bloomFilterList = bloomFilterIndex.getBloomFilterList();
        for (int i = 0; i < bloomFilterList.size(); ++i) {
            OrcProto.BloomFilter bf = (OrcProto.BloomFilter)bloomFilterList.get(i);
            BloomFilter bloomFilter = BloomFilterIO.deserialize((OrcProto.Stream.Kind)indices.getBloomFilterKinds()[colIndex], (OrcProto.ColumnEncoding)columnEncoding, (OrcFile.WriterVersion)reader.getWriterVersion(), (TypeDescription.Category)columnCategory, (OrcProto.BloomFilter)bf);
            for (String value : values) {
                boolean testResult = CheckTool.test(bloomFilter, columnCategory, value);
                if (testResult) {
                    System.out.printf("stripe: %d, rowIndex: %d, value: %s, bloom filter: maybe exist%n", stripeIndex, i, value);
                    continue;
                }
                System.out.printf("stripe: %d, rowIndex: %d, value: %s, bloom filter: not exist%n", stripeIndex, i, value);
            }
        }
    }

    private static boolean test(BloomFilter bloomFilter, TypeDescription.Category columnCategory, String value) {
        switch (columnCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: 
            case TIMESTAMP: {
                return bloomFilter.testLong(Long.parseLong(value));
            }
            case FLOAT: 
            case DOUBLE: {
                return bloomFilter.testDouble(Double.parseDouble(value));
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DECIMAL: {
                return bloomFilter.testString(value);
            }
        }
        throw new IllegalStateException("Not supported type:" + String.valueOf(columnCategory));
    }

    private static Object convert(TypeDescription.Category columnCategory, String value) {
        switch (columnCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: 
            case TIMESTAMP: {
                return Long.parseLong(value);
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DECIMAL: {
                return value;
            }
        }
        throw new IllegalStateException("Not supported type:" + String.valueOf(columnCategory));
    }

    private static PredicateLeaf.Type getPredicateLeafType(TypeDescription.Category columnCategory) {
        switch (columnCategory) {
            case BOOLEAN: {
                return PredicateLeaf.Type.BOOLEAN;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return PredicateLeaf.Type.LONG;
            }
            case DATE: {
                return PredicateLeaf.Type.DATE;
            }
            case TIMESTAMP: {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            case FLOAT: 
            case DOUBLE: {
                return PredicateLeaf.Type.FLOAT;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DECIMAL: {
                return PredicateLeaf.Type.STRING;
            }
        }
        throw new IllegalStateException("Not supported type:" + String.valueOf(columnCategory));
    }

    private static PredicateLeaf createPredicateLeaf(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal) {
        return new SearchArgumentImpl.PredicateLeafImpl(operator, type, columnName, literal, null);
    }

    private static Options createOptions() {
        Options result = new Options();
        result.addOption(Option.builder((String)"t").longOpt("type").desc(String.format("check type = {%s, %s, %s}", CHECK_TYPE_PREDICATE, CHECK_TYPE_STAT, CHECK_TYPE_BLOOM_FILTER)).hasArg().build());
        result.addOption(Option.builder((String)"col").longOpt("column").desc("column name").hasArg().build());
        result.addOption(Option.builder((String)"v").longOpt("values").desc("test values").hasArgs().build());
        result.addOption(Option.builder((String)"h").longOpt("help").desc("print help message").build());
        return result;
    }
}

