/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.base.Joiner;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.JsonSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.streaming.AbstractRecordWriter;
import org.apache.hive.streaming.SerializationError;

public class StrictJsonWriter
extends AbstractRecordWriter {
    private JsonSerDe serde;

    public StrictJsonWriter(Builder builder) {
        super(builder.lineDelimiter);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public JsonSerDe createSerde() throws SerializationError {
        try {
            Properties tableProps = this.table.getMetadata();
            tableProps.setProperty("columns", Joiner.on((String)",").join((Iterable)this.inputColumns));
            tableProps.setProperty("columns.types", Joiner.on((String)":").join((Iterable)this.inputTypes));
            JsonSerDe serde = new JsonSerDe();
            serde.initialize((Configuration)this.conf, tableProps, null);
            this.serde = serde;
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + JsonSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    @Override
    public Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }

    public static class Builder {
        private String lineDelimiter;

        public Builder withLineDelimiterPattern(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public StrictJsonWriter build() {
            return new StrictJsonWriter(this);
        }
    }
}

