/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.admin;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafkaesque.clients.admin.AdminClientConfig;
import org.apache.kafkaesque.clients.admin.AlterConfigOp;
import org.apache.kafkaesque.clients.admin.AlterConfigsOptions;
import org.apache.kafkaesque.clients.admin.AlterConfigsResult;
import org.apache.kafkaesque.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafkaesque.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafkaesque.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafkaesque.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafkaesque.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafkaesque.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafkaesque.clients.admin.Config;
import org.apache.kafkaesque.clients.admin.CreateAclsOptions;
import org.apache.kafkaesque.clients.admin.CreateAclsResult;
import org.apache.kafkaesque.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafkaesque.clients.admin.CreateDelegationTokenResult;
import org.apache.kafkaesque.clients.admin.CreatePartitionsOptions;
import org.apache.kafkaesque.clients.admin.CreatePartitionsResult;
import org.apache.kafkaesque.clients.admin.CreateTopicsOptions;
import org.apache.kafkaesque.clients.admin.CreateTopicsResult;
import org.apache.kafkaesque.clients.admin.DeleteAclsOptions;
import org.apache.kafkaesque.clients.admin.DeleteAclsResult;
import org.apache.kafkaesque.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafkaesque.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafkaesque.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafkaesque.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafkaesque.clients.admin.DeleteRecordsOptions;
import org.apache.kafkaesque.clients.admin.DeleteRecordsResult;
import org.apache.kafkaesque.clients.admin.DeleteTopicsOptions;
import org.apache.kafkaesque.clients.admin.DeleteTopicsResult;
import org.apache.kafkaesque.clients.admin.DescribeAclsOptions;
import org.apache.kafkaesque.clients.admin.DescribeAclsResult;
import org.apache.kafkaesque.clients.admin.DescribeClusterOptions;
import org.apache.kafkaesque.clients.admin.DescribeClusterResult;
import org.apache.kafkaesque.clients.admin.DescribeConfigsOptions;
import org.apache.kafkaesque.clients.admin.DescribeConfigsResult;
import org.apache.kafkaesque.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafkaesque.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafkaesque.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafkaesque.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafkaesque.clients.admin.DescribeLogDirsOptions;
import org.apache.kafkaesque.clients.admin.DescribeLogDirsResult;
import org.apache.kafkaesque.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafkaesque.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafkaesque.clients.admin.DescribeTopicsOptions;
import org.apache.kafkaesque.clients.admin.DescribeTopicsResult;
import org.apache.kafkaesque.clients.admin.ElectLeadersOptions;
import org.apache.kafkaesque.clients.admin.ElectLeadersResult;
import org.apache.kafkaesque.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafkaesque.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafkaesque.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafkaesque.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafkaesque.clients.admin.KafkaAdminClient;
import org.apache.kafkaesque.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafkaesque.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafkaesque.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafkaesque.clients.admin.ListConsumerGroupsResult;
import org.apache.kafkaesque.clients.admin.ListOffsetsOptions;
import org.apache.kafkaesque.clients.admin.ListOffsetsResult;
import org.apache.kafkaesque.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafkaesque.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafkaesque.clients.admin.ListTopicsOptions;
import org.apache.kafkaesque.clients.admin.ListTopicsResult;
import org.apache.kafkaesque.clients.admin.NewPartitionReassignment;
import org.apache.kafkaesque.clients.admin.NewPartitions;
import org.apache.kafkaesque.clients.admin.NewTopic;
import org.apache.kafkaesque.clients.admin.OffsetSpec;
import org.apache.kafkaesque.clients.admin.RecordsToDelete;
import org.apache.kafkaesque.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafkaesque.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafkaesque.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafkaesque.clients.admin.RenewDelegationTokenResult;
import org.apache.kafkaesque.clients.consumer.OffsetAndMetadata;
import org.apache.kafkaesque.common.ElectionType;
import org.apache.kafkaesque.common.Metric;
import org.apache.kafkaesque.common.MetricName;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.TopicPartitionReplica;
import org.apache.kafkaesque.common.acl.AclBinding;
import org.apache.kafkaesque.common.acl.AclBindingFilter;
import org.apache.kafkaesque.common.annotation.InterfaceStability;
import org.apache.kafkaesque.common.config.ConfigResource;

@InterfaceStability.Evolving
public interface Admin
extends AutoCloseable {
    public static Admin create(Properties props) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(props, true), null);
    }

    public static Admin create(Map<String, Object> conf) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(conf, true), null);
    }

    @Override
    default public void close() {
        this.close(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void close(long duration, TimeUnit unit) {
        this.close(Duration.ofMillis(unit.toMillis(duration)));
    }

    public void close(Duration var1);

    default public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.createTopics(newTopics, new CreateTopicsOptions());
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> var1, CreateTopicsOptions var2);

    default public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.deleteTopics(topics, new DeleteTopicsOptions());
    }

    public DeleteTopicsResult deleteTopics(Collection<String> var1, DeleteTopicsOptions var2);

    default public ListTopicsResult listTopics() {
        return this.listTopics(new ListTopicsOptions());
    }

    public ListTopicsResult listTopics(ListTopicsOptions var1);

    default public DescribeTopicsResult describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, new DescribeTopicsOptions());
    }

    public DescribeTopicsResult describeTopics(Collection<String> var1, DescribeTopicsOptions var2);

    default public DescribeClusterResult describeCluster() {
        return this.describeCluster(new DescribeClusterOptions());
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions var1);

    default public DescribeAclsResult describeAcls(AclBindingFilter filter) {
        return this.describeAcls(filter, new DescribeAclsOptions());
    }

    public DescribeAclsResult describeAcls(AclBindingFilter var1, DescribeAclsOptions var2);

    default public CreateAclsResult createAcls(Collection<AclBinding> acls) {
        return this.createAcls(acls, new CreateAclsOptions());
    }

    public CreateAclsResult createAcls(Collection<AclBinding> var1, CreateAclsOptions var2);

    default public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
        return this.deleteAcls(filters, new DeleteAclsOptions());
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> var1, DeleteAclsOptions var2);

    default public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources) {
        return this.describeConfigs(resources, new DescribeConfigsOptions());
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> var1, DescribeConfigsOptions var2);

    @Deprecated
    default public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs) {
        return this.alterConfigs(configs, new AlterConfigsOptions());
    }

    @Deprecated
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> var1, AlterConfigsOptions var2);

    default public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs) {
        return this.incrementalAlterConfigs(configs, new AlterConfigsOptions());
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> var1, AlterConfigsOptions var2);

    default public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment) {
        return this.alterReplicaLogDirs(replicaAssignment, new AlterReplicaLogDirsOptions());
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> var1, AlterReplicaLogDirsOptions var2);

    default public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers) {
        return this.describeLogDirs(brokers, new DescribeLogDirsOptions());
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> var1, DescribeLogDirsOptions var2);

    default public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas) {
        return this.describeReplicaLogDirs(replicas, new DescribeReplicaLogDirsOptions());
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> var1, DescribeReplicaLogDirsOptions var2);

    default public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions) {
        return this.createPartitions(newPartitions, new CreatePartitionsOptions());
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> var1, CreatePartitionsOptions var2);

    default public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete) {
        return this.deleteRecords(recordsToDelete, new DeleteRecordsOptions());
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> var1, DeleteRecordsOptions var2);

    default public CreateDelegationTokenResult createDelegationToken() {
        return this.createDelegationToken(new CreateDelegationTokenOptions());
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions var1);

    default public RenewDelegationTokenResult renewDelegationToken(byte[] hmac) {
        return this.renewDelegationToken(hmac, new RenewDelegationTokenOptions());
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] var1, RenewDelegationTokenOptions var2);

    default public ExpireDelegationTokenResult expireDelegationToken(byte[] hmac) {
        return this.expireDelegationToken(hmac, new ExpireDelegationTokenOptions());
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] var1, ExpireDelegationTokenOptions var2);

    default public DescribeDelegationTokenResult describeDelegationToken() {
        return this.describeDelegationToken(new DescribeDelegationTokenOptions());
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions var1);

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> var1, DescribeConsumerGroupsOptions var2);

    default public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds) {
        return this.describeConsumerGroups(groupIds, new DescribeConsumerGroupsOptions());
    }

    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions var1);

    default public ListConsumerGroupsResult listConsumerGroups() {
        return this.listConsumerGroups(new ListConsumerGroupsOptions());
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2);

    default public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> var1, DeleteConsumerGroupsOptions var2);

    default public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds) {
        return this.deleteConsumerGroups(groupIds, new DeleteConsumerGroupsOptions());
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2, DeleteConsumerGroupOffsetsOptions var3);

    default public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return this.deleteConsumerGroupOffsets(groupId, partitions, new DeleteConsumerGroupOffsetsOptions());
    }

    @Deprecated
    default public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions) {
        return this.electPreferredLeaders(partitions, new ElectPreferredLeadersOptions());
    }

    @Deprecated
    default public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions, ElectPreferredLeadersOptions options) {
        ElectLeadersOptions newOptions = new ElectLeadersOptions();
        newOptions.timeoutMs(options.timeoutMs());
        HashSet<TopicPartition> topicPartitions = partitions == null ? null : new HashSet<TopicPartition>(partitions);
        return new ElectPreferredLeadersResult(this.electLeaders(ElectionType.PREFERRED, topicPartitions, newOptions));
    }

    default public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions) {
        return this.electLeaders(electionType, partitions, new ElectLeadersOptions());
    }

    public ElectLeadersResult electLeaders(ElectionType var1, Set<TopicPartition> var2, ElectLeadersOptions var3);

    default public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments) {
        return this.alterPartitionReassignments(reassignments, new AlterPartitionReassignmentsOptions());
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> var1, AlterPartitionReassignmentsOptions var2);

    default public ListPartitionReassignmentsResult listPartitionReassignments() {
        return this.listPartitionReassignments(new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions) {
        return this.listPartitionReassignments(partitions, new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions, ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.of(partitions), options);
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.empty(), options);
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> var1, ListPartitionReassignmentsOptions var2);

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String var1, RemoveMembersFromConsumerGroupOptions var2);

    default public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.alterConsumerGroupOffsets(groupId, offsets, new AlterConsumerGroupOffsetsOptions());
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2, AlterConsumerGroupOffsetsOptions var3);

    default public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets) {
        return this.listOffsets(topicPartitionOffsets, new ListOffsetsOptions());
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> var1, ListOffsetsOptions var2);

    public Map<MetricName, ? extends Metric> metrics();
}

