/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.filters.bloomfilter.BloomFilter;
import org.apache.datasketches.memory.WritableMemory;

public final class BloomFilterBuilder {
    public static short suggestNumHashes(long maxDistinctItems, long numFilterBits) {
        if (maxDistinctItems < 1L || numFilterBits < 1L) {
            throw new SketchesArgumentException("maxDistinctItems and numFilterBits must be strictly positive");
        }
        return (short)Math.max(1, (int)Math.ceil((double)numFilterBits / (double)maxDistinctItems * Math.log(2.0)));
    }

    public static short suggestNumHashes(double targetFalsePositiveProb) {
        if (targetFalsePositiveProb <= 0.0 || targetFalsePositiveProb > 1.0) {
            throw new SketchesArgumentException("targetFalsePositiveProb must be a valid probability and strictly greater than 0");
        }
        return (short)Math.ceil(-Math.log(targetFalsePositiveProb) / Math.log(2.0));
    }

    public static long suggestNumFilterBits(long maxDistinctItems, double targetFalsePositiveProb) {
        BloomFilterBuilder.validateAccuracyInputs(maxDistinctItems, targetFalsePositiveProb);
        return (long)Math.ceil((double)(-maxDistinctItems) * Math.log(targetFalsePositiveProb) / (Math.log(2.0) * Math.log(2.0)));
    }

    public static long getSerializedFilterSizeByAccuracy(long maxDistinctItems, double targetFalsePositiveProb) {
        BloomFilterBuilder.validateAccuracyInputs(maxDistinctItems, targetFalsePositiveProb);
        return BloomFilter.getSerializedSize(BloomFilterBuilder.suggestNumFilterBits(maxDistinctItems, targetFalsePositiveProb));
    }

    public static long getSerializedFilterSize(long numBits) {
        BloomFilterBuilder.validateSizeInputs(numBits, 1);
        return BloomFilter.getSerializedSize(numBits);
    }

    public static BloomFilter createByAccuracy(long maxDistinctItems, double targetFalsePositiveProb) {
        BloomFilterBuilder.validateAccuracyInputs(maxDistinctItems, targetFalsePositiveProb);
        return BloomFilterBuilder.createByAccuracy(maxDistinctItems, targetFalsePositiveProb, ThreadLocalRandom.current().nextLong());
    }

    public static BloomFilter createByAccuracy(long maxDistinctItems, double targetFalsePositiveProb, long seed) {
        BloomFilterBuilder.validateAccuracyInputs(maxDistinctItems, targetFalsePositiveProb);
        long numBits = BloomFilterBuilder.suggestNumFilterBits(maxDistinctItems, targetFalsePositiveProb);
        short numHashes = BloomFilterBuilder.suggestNumHashes(maxDistinctItems, numBits);
        return new BloomFilter(numBits, numHashes, seed);
    }

    public static BloomFilter createBySize(long numBits, int numHashes) {
        return BloomFilterBuilder.createBySize(numBits, numHashes, ThreadLocalRandom.current().nextLong());
    }

    public static BloomFilter createBySize(long numBits, int numHashes, long seed) {
        BloomFilterBuilder.validateSizeInputs(numBits, numHashes);
        return new BloomFilter(numBits, numHashes, seed);
    }

    public static BloomFilter initializeByAccuracy(long maxDistinctItems, double targetFalsePositiveProb, WritableMemory dstMem) {
        return BloomFilterBuilder.initializeByAccuracy(maxDistinctItems, targetFalsePositiveProb, ThreadLocalRandom.current().nextLong(), dstMem);
    }

    public static BloomFilter initializeByAccuracy(long maxDistinctItems, double targetFalsePositiveProb, long seed, WritableMemory dstMem) {
        BloomFilterBuilder.validateAccuracyInputs(maxDistinctItems, targetFalsePositiveProb);
        long numBits = BloomFilterBuilder.suggestNumFilterBits(maxDistinctItems, targetFalsePositiveProb);
        short numHashes = BloomFilterBuilder.suggestNumHashes(maxDistinctItems, numBits);
        if (dstMem.getCapacity() < BloomFilter.getSerializedSize(numBits)) {
            throw new SketchesArgumentException("Provided WritableMemory is insufficient to hold requested filter");
        }
        return new BloomFilter(numBits, numHashes, seed, dstMem);
    }

    public static BloomFilter initializeBySize(long numBits, int numHashes, WritableMemory dstMem) {
        return BloomFilterBuilder.initializeBySize(numBits, numHashes, ThreadLocalRandom.current().nextLong(), dstMem);
    }

    public static BloomFilter initializeBySize(long numBits, int numHashes, long seed, WritableMemory dstMem) {
        BloomFilterBuilder.validateSizeInputs(numBits, numHashes);
        if (dstMem.getCapacity() < BloomFilter.getSerializedSize(numBits)) {
            throw new SketchesArgumentException("Provided WritableMemory is insufficient to hold requested filter");
        }
        return new BloomFilter(numBits, numHashes, seed, dstMem);
    }

    private static void validateAccuracyInputs(long maxDistinctItems, double targetFalsePositiveProb) {
        if (maxDistinctItems <= 0L) {
            throw new SketchesArgumentException("maxDistinctItems must be strictly positive");
        }
        if (targetFalsePositiveProb <= 0.0 || targetFalsePositiveProb > 1.0) {
            throw new SketchesArgumentException("targetFalsePositiveProb must be a valid probability and strictly greater than 0");
        }
    }

    private static void validateSizeInputs(long numBits, int numHashes) {
        if (numBits < 0L) {
            throw new SketchesArgumentException("Size of BloomFilter must be strictly positive. Requested: " + numBits);
        }
        if (numBits > BloomFilter.MAX_SIZE_BITS) {
            throw new SketchesArgumentException("Size of BloomFilter must be <= " + BloomFilter.MAX_SIZE_BITS + ". Requested: " + numBits);
        }
        if (numHashes < 1) {
            throw new SketchesArgumentException("Must specify a strictly positive number of hash functions. Requested: " + numHashes);
        }
        if (numHashes > Short.MAX_VALUE) {
            throw new SketchesArgumentException("Number of hashes cannot exceed 32767. Requested: " + numHashes);
        }
    }
}

