/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.EncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.io.filter.FilterContext;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.TreeReaderFactory;
import org.apache.orc.impl.WriterImpl;
import org.apache.orc.impl.reader.tree.TypeReader;

public class OrcEncodedDataConsumer
extends EncodedDataConsumer<OrcBatchKey, Reader.OrcEncodedColumnBatch> {
    private TypeReader[] columnReaders;
    private int previousStripeIndex = -1;
    private ConsumerFileMetadata fileMetadata;
    private CompressionCodec codec;
    private List<ConsumerStripeMetadata> stripes;
    private SchemaEvolution evolution;
    private IoTrace trace;
    private final ColumnVectorProducer.Includes includes;
    private TypeDescription[] batchSchemas;
    private boolean useDecimal64ColumnVectors;

    public OrcEncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, ColumnVectorProducer.Includes includes, QueryFragmentCounters counters, LlapDaemonIOMetrics ioMetrics) {
        super(consumer, includes.getPhysicalColumnIds().size(), ioMetrics, counters);
        this.includes = includes;
        if (includes.isProbeDecodeEnabled()) {
            LlapIoImpl.LOG.info("OrcEncodedDataConsumer probeDecode is enabled with cacheKey {} colIndex {} and colName {}", new Object[]{this.includes.getProbeCacheKey(), this.includes.getProbeColIdx(), this.includes.getProbeColName()});
        }
    }

    public void setUseDecimal64ColumnVectors(boolean useDecimal64ColumnVectors) {
        this.useDecimal64ColumnVectors = useDecimal64ColumnVectors;
    }

    public void setFileMetadata(ConsumerFileMetadata f) {
        assert (this.fileMetadata == null);
        this.fileMetadata = f;
        this.stripes = new ArrayList<ConsumerStripeMetadata>(f.getStripeCount());
        this.codec = WriterImpl.createCodec((CompressionKind)this.fileMetadata.getCompressionKind());
    }

    public void setStripeMetadata(ConsumerStripeMetadata m) {
        assert (this.stripes != null);
        int newIx = m.getStripeIx();
        for (int i = this.stripes.size(); i <= newIx; ++i) {
            this.stripes.add(null);
        }
        assert (this.stripes.get(newIx) == null);
        this.stripes.set(newIx, m);
    }

    @Override
    protected void decodeBatch(Reader.OrcEncodedColumnBatch batch, Consumer<ColumnVectorBatch> downstreamConsumer) throws InterruptedException {
        long startTime = this.counters.startTimeCounter();
        int currentStripeIndex = ((OrcBatchKey)batch.getBatchKey()).stripeIx;
        boolean sameStripe = currentStripeIndex == this.previousStripeIndex;
        try {
            long nonNullRowCount;
            ConsumerStripeMetadata stripeMetadata = this.stripes.get(currentStripeIndex);
            int rgIdx = ((OrcBatchKey)batch.getBatchKey()).rgIx;
            boolean noIndex = false;
            if (rgIdx == -1) {
                nonNullRowCount = stripeMetadata.getRowCount();
            } else {
                OrcProto.RowIndexEntry rowIndex = stripeMetadata.getRowIndexEntry(0, rgIdx);
                if (rowIndex == null) {
                    nonNullRowCount = stripeMetadata.getRowCount();
                    noIndex = true;
                } else {
                    nonNullRowCount = this.getRowCount(rowIndex);
                }
            }
            int maxBatchesRG = (int)(nonNullRowCount / 1024L + 1L);
            int batchSize = 1024;
            TypeDescription fileSchema = this.fileMetadata.getSchema();
            if (this.columnReaders == null || !sameStripe || noIndex) {
                this.createColumnReaders(batch, stripeMetadata, fileSchema);
            } else {
                this.repositionInStreams(this.columnReaders, (EncodedColumnBatch<OrcBatchKey>)batch, sameStripe, stripeMetadata);
            }
            this.previousStripeIndex = currentStripeIndex;
            for (int i = 0; i < maxBatchesRG && (i != maxBatchesRG - 1 || (batchSize = (int)(nonNullRowCount % 1024L)) != 0); ++i) {
                ColumnVectorBatch cvb = (ColumnVectorBatch)this.cvbPool.take();
                cvb.filterContext.reset();
                cvb.size = batchSize;
                for (int idx = 0; idx < this.columnReaders.length; ++idx) {
                    TypeReader reader = this.columnReaders[idx];
                    ColumnVector cv = this.prepareColumnVector(cvb, idx, batchSize);
                    reader.nextVector(cv, null, batchSize, (FilterContext)cvb.filterContext, TypeReader.ReadPhase.ALL);
                }
                downstreamConsumer.consumeData((Object)cvb);
                this.counters.incrCounter(LlapIOCounters.ROWS_EMITTED, batchSize);
            }
            LlapIoImpl.ORC_LOGGER.debug("Done with decode");
            this.counters.incrWallClockCounter(LlapIOCounters.DECODE_TIME_NS, startTime);
            this.counters.incrCounter(LlapIOCounters.NUM_VECTOR_BATCHES, maxBatchesRG);
            this.counters.incrCounter(LlapIOCounters.NUM_DECODED_BATCHES);
        }
        catch (IOException e) {
            downstreamConsumer.setError((Throwable)e);
        }
    }

    private ColumnVector prepareColumnVector(ColumnVectorBatch cvb, int idx, int batchSize) {
        if (cvb.cols[idx] == null) {
            cvb.cols[idx] = this.createColumn(this.batchSchemas[idx], 1024, this.useDecimal64ColumnVectors);
        }
        this.trace.logTreeReaderNextVector(idx);
        ColumnVector cv = cvb.cols[idx];
        cv.reset();
        cv.ensureSize(batchSize, false);
        return cv;
    }

    private void createColumnReaders(Reader.OrcEncodedColumnBatch batch, ConsumerStripeMetadata stripeMetadata, TypeDescription fileSchema) throws IOException {
        TreeReaderFactory.ReaderContext context = new TreeReaderFactory.ReaderContext().setSchemaEvolution(this.evolution).writerTimeZone(stripeMetadata.getWriterTimezone()).fileFormat(this.fileMetadata == null ? null : this.fileMetadata.getFileVersion()).useUTCTimestamp(true).setProlepticGregorian(this.fileMetadata != null && this.fileMetadata.getCalendar() == OrcProto.CalendarKind.PROLEPTIC_GREGORIAN, true);
        this.batchSchemas = this.includes.getBatchReaderTypes(fileSchema);
        TreeReaderFactory.StructTreeReader treeReader = EncodedTreeReaderFactory.createRootTreeReader((TypeDescription[])this.batchSchemas, stripeMetadata.getEncodings(), (Reader.OrcEncodedColumnBatch)batch, (CompressionCodec)this.codec, (TreeReaderFactory.Context)context, (boolean)this.useDecimal64ColumnVectors);
        this.columnReaders = treeReader.getChildReaders();
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            for (int i = 0; i < this.columnReaders.length; ++i) {
                LlapIoImpl.LOG.debug("Created a reader at " + i + ": " + String.valueOf(this.columnReaders[i]) + " from schema " + String.valueOf(this.batchSchemas[i]));
            }
        }
        this.positionInStreams(this.columnReaders, (OrcBatchKey)batch.getBatchKey(), stripeMetadata);
    }

    private ColumnVector createColumn(TypeDescription type, int batchSize, boolean useDecimal64ColumnVectors) {
        switch (type.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongColumnVector(batchSize);
            }
            case DATE: {
                return new DateColumnVector(batchSize);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleColumnVector(batchSize);
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new BytesColumnVector(batchSize);
            }
            case TIMESTAMP: {
                return new TimestampColumnVector(batchSize);
            }
            case DECIMAL: {
                if (useDecimal64ColumnVectors && type.getPrecision() <= 18) {
                    return new Decimal64ColumnVector(batchSize, type.getPrecision(), type.getScale());
                }
                return new DecimalColumnVector(batchSize, type.getPrecision(), type.getScale());
            }
            case STRUCT: {
                List subtypeIdxs = type.getChildren();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = this.createColumn((TypeDescription)subtypeIdxs.get(i), batchSize, useDecimal64ColumnVectors);
                }
                return new StructColumnVector(batchSize, fieldVector);
            }
            case UNION: {
                List subtypeIdxs = type.getChildren();
                ColumnVector[] fieldVector = new ColumnVector[subtypeIdxs.size()];
                for (int i = 0; i < fieldVector.length; ++i) {
                    fieldVector[i] = this.createColumn((TypeDescription)subtypeIdxs.get(i), batchSize, useDecimal64ColumnVectors);
                }
                return new UnionColumnVector(batchSize, fieldVector);
            }
            case LIST: {
                return new ListColumnVector(batchSize, this.createColumn((TypeDescription)type.getChildren().get(0), batchSize, useDecimal64ColumnVectors));
            }
            case MAP: {
                List subtypeIdxs = type.getChildren();
                return new MapColumnVector(batchSize, this.createColumn((TypeDescription)subtypeIdxs.get(0), batchSize, useDecimal64ColumnVectors), this.createColumn((TypeDescription)subtypeIdxs.get(1), batchSize, useDecimal64ColumnVectors));
            }
        }
        throw new IllegalArgumentException("LLAP does not support " + String.valueOf(type.getCategory()));
    }

    private void positionInStreams(TypeReader[] columnReaders, OrcBatchKey batchKey, ConsumerStripeMetadata stripeMetadata) throws IOException {
        PositionProvider[] pps = this.createPositionProviders(columnReaders, batchKey, stripeMetadata);
        if (pps == null) {
            return;
        }
        for (int i = 0; i < columnReaders.length; ++i) {
            if (columnReaders[i] == null) continue;
            columnReaders[i].seek(pps, TypeReader.ReadPhase.ALL);
        }
    }

    private void repositionInStreams(TypeReader[] columnReaders, EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe, ConsumerStripeMetadata stripeMetadata) throws IOException {
        Object[] pps = this.createPositionProviders(columnReaders, (OrcBatchKey)batch.getBatchKey(), stripeMetadata);
        if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
            LlapIoImpl.ORC_LOGGER.trace("Created pps {}", (Object)Arrays.toString(pps));
        }
        if (pps == null) {
            return;
        }
        for (int i = 0; i < columnReaders.length; ++i) {
            TypeReader reader = columnReaders[i];
            if (reader == null) continue;
            ((EncodedTreeReaderFactory.SettableTreeReader)reader).setBuffers(batch, sameStripe);
            if (reader instanceof EncodedTreeReaderFactory.TimestampStreamReader && !sameStripe) {
                ((EncodedTreeReaderFactory.TimestampStreamReader)reader).updateTimezone(stripeMetadata.getWriterTimezone());
            }
            reader.seek((PositionProvider[])pps, TypeReader.ReadPhase.ALL);
        }
    }

    private PositionProvider[] createPositionProviders(TypeReader[] columnReaders, OrcBatchKey batchKey, ConsumerStripeMetadata stripeMetadata) throws IOException {
        if (columnReaders.length == 0) {
            return null;
        }
        PositionProvider[] pps = null;
        if (!stripeMetadata.supportsRowIndexes()) {
            IndexlessPositionProvider singleRgPp = new IndexlessPositionProvider();
            pps = new PositionProvider[stripeMetadata.getEncodings().size()];
            for (int i = 0; i < pps.length; ++i) {
                pps[i] = singleRgPp;
            }
        } else {
            int rowGroupIndex = batchKey.rgIx;
            if (rowGroupIndex == -1) {
                throw new IOException("Cannot position readers without RG information");
            }
            OrcProto.RowIndex[] ris = stripeMetadata.getRowIndexes();
            pps = new PositionProvider[ris.length];
            for (int i = 0; i < ris.length; ++i) {
                OrcProto.RowIndex ri = ris[i];
                if (ri == null) continue;
                pps[i] = new RecordReaderImpl.PositionProviderImpl(ri.getEntry(rowGroupIndex));
            }
        }
        return pps;
    }

    private long getRowCount(OrcProto.RowIndexEntry rowIndexEntry) {
        return rowIndexEntry.getStatistics().getNumberOfValues();
    }

    public void setSchemaEvolution(SchemaEvolution evolution) {
        this.evolution = evolution;
    }

    @Override
    public SchemaEvolution getSchemaEvolution() {
        return this.evolution;
    }

    public void init(ConsumerFeedback<Reader.OrcEncodedColumnBatch> upstreamFeedback, Callable<Void> readCallable, IoTrace trace) {
        super.init(upstreamFeedback, readCallable);
        this.trace = trace;
    }

    private static final class IndexlessPositionProvider
    implements PositionProvider {
        private IndexlessPositionProvider() {
        }

        public long getNext() {
            return 0L;
        }

        public String toString() {
            return "indexes not supported";
        }
    }
}

