/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.List;
import java.util.function.Predicate;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;

public class SimpleBufferManager
implements BufferUsageManager,
LowLevelCache {
    private final Allocator allocator;
    private final LlapDaemonCacheMetrics metrics;

    public SimpleBufferManager(Allocator allocator, LlapDaemonCacheMetrics metrics) {
        LlapIoImpl.LOG.info("Simple buffer manager");
        this.allocator = allocator;
        this.metrics = metrics;
    }

    private boolean lockBuffer(LlapAllocatorBuffer buffer) {
        int rc = buffer.incRef();
        if (rc <= 0) {
            return false;
        }
        this.metrics.incrCacheNumLockedBuffers();
        return true;
    }

    private void unlockBuffer(LlapAllocatorBuffer buffer) {
        if (buffer.decRef() == 0) {
            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                LlapIoImpl.CACHE_LOGGER.trace("Deallocating {} that was not cached", (Object)buffer);
            }
            this.allocator.deallocate((MemoryBuffer)buffer);
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    @Override
    public void decRefBuffer(MemoryBuffer buffer) {
        this.unlockBuffer((LlapAllocatorBuffer)buffer);
    }

    @Override
    public void decRefBuffers(List<MemoryBuffer> cacheBuffers) {
        for (MemoryBuffer b : cacheBuffers) {
            this.unlockBuffer((LlapAllocatorBuffer)b);
        }
    }

    @Override
    public boolean incRefBuffer(MemoryBuffer buffer) {
        return this.lockBuffer((LlapAllocatorBuffer)buffer);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, LowLevelCacheCounters qfCounters, DataCache.BooleanRef gotAllData) {
        return range;
    }

    @Override
    public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] chunks, long baseOffset, LowLevelCache.Priority priority, LowLevelCacheCounters qfCounters, CacheTag tag) {
        for (int i = 0; i < chunks.length; ++i) {
            LlapAllocatorBuffer buffer = (LlapAllocatorBuffer)chunks[i];
            if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                LlapIoImpl.LOCKING_LOGGER.trace("Locking {} at put time (no cache)", (Object)buffer);
            }
            boolean canLock = this.lockBuffer(buffer);
            assert (canLock);
        }
        return null;
    }

    @Override
    public void notifyEvicted(MemoryBuffer buffer) {
        throw new UnsupportedOperationException("Buffer manager doesn't have cache");
    }

    @Override
    public long markBuffersForProactiveEviction(Predicate<CacheTag> predicate, boolean isInstantDeallocation) {
        throw new UnsupportedOperationException("Buffer manager doesn't have cache");
    }
}

