/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LlapCacheHydration
extends Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(LlapCacheHydration.class);

    public void save();

    public void load();

    public void init();

    public static void setupAndStartIfEnabled(Configuration conf) {
        String clazz = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_HYDRATION_STRATEGY_CLASS);
        if (!StringUtils.isEmpty((CharSequence)clazz)) {
            try {
                LlapCacheHydration strategy = (LlapCacheHydration)ReflectionUtil.newInstance(Class.forName(clazz).asSubclass(LlapCacheHydration.class), (Configuration)conf);
                strategy.init();
                Runner runner = new Runner(strategy);
                Thread t = new Thread((Runnable)runner, "LlapCacheHydrationRunner");
                t.start();
            }
            catch (Exception ex) {
                LOG.warn("Llap cache hydration error.", (Throwable)ex);
            }
        }
    }

    public static final class Runner
    implements Runnable {
        private static final String THREAD_NAME = "LlapCacheHydrationRunner";
        private final LlapCacheHydration strategy;

        public Runner(LlapCacheHydration strategy) {
            this.strategy = strategy;
        }

        @Override
        public void run() {
            this.strategy.load();
        }
    }
}

