/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class FindColumnsWithStatsHandler
implements QueryHandler<List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(FindColumnsWithStatsHandler.class);
    private static final String TABLE_SELECT = "SELECT \"COLUMN_NAME\" FROM \"TAB_COL_STATS\" INNER JOIN \"TBLS\" ON \"TAB_COL_STATS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\" INNER JOIN \"DBS\" ON \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\" WHERE \"DBS\".\"NAME\" = :dbName AND \"TBLS\".\"TBL_NAME\" = :tableName";
    private static final String PARTITION_SELECT = "SELECT \"COLUMN_NAME\" FROM \"PART_COL_STATS\" INNER JOIN \"PARTITIONS\" ON \"PART_COL_STATS\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\" INNER JOIN \"TBLS\" ON \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\" INNER JOIN \"DBS\" ON \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\" WHERE \"DBS\".\"NAME\" = :dbName AND \"TBLS\".\"TBL_NAME\" = :tableName AND \"PARTITIONS\".\"PART_NAME\" = :partName";
    private final CompactionInfo ci;

    public FindColumnsWithStatsHandler(CompactionInfo ci) {
        this.ci = ci;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) {
        return this.ci.partName != null ? PARTITION_SELECT : TABLE_SELECT;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("dbName", (Object)this.ci.dbname).addValue("tableName", (Object)this.ci.tableName);
        if (this.ci.partName != null) {
            params.addValue("partName", (Object)this.ci.partName);
        }
        return params;
    }

    public List<String> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<String> columns = new ArrayList<String>();
        while (rs.next()) {
            columns.add(rs.getString(1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found columns to update stats: {} on {}{}", new Object[]{columns, this.ci.tableName, this.ci.partName == null ? "" : "/" + this.ci.partName});
        }
        return columns;
    }
}

