/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CompactionMetricsDataHandler
implements QueryHandler<CompactionMetricsData> {
    private static final String SELECT_COMPACTION_METRICS_CACHE = "SELECT \"CMC_METRIC_VALUE\", \"CMC_VERSION\" FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_DATABASE\" = :db AND \"CMC_TABLE\" = :table AND \"CMC_METRIC_TYPE\" = :type AND (:partition IS NULL OR \"CMC_PARTITION\" = :partition)";
    private final String dbName;
    private final String tblName;
    private final String partitionName;
    private final CompactionMetricsData.MetricType type;

    public CompactionMetricsDataHandler(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) {
        this.dbName = dbName;
        this.tblName = tblName;
        this.partitionName = partitionName;
        this.type = type;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return SELECT_COMPACTION_METRICS_CACHE;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("db", (Object)this.dbName).addValue("table", (Object)this.tblName).addValue("type", (Object)this.type.toString()).addValue("partition", (Object)this.partitionName, 12);
    }

    public CompactionMetricsData extractData(ResultSet rs) throws SQLException, DataAccessException {
        CompactionMetricsData.Builder builder = new CompactionMetricsData.Builder();
        if (rs.next()) {
            return builder.dbName(this.dbName).tblName(this.tblName).partitionName(this.partitionName).metricType(this.type).metricValue(rs.getInt(1)).version(rs.getInt(2)).build();
        }
        return null;
    }
}

