/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.time.Instant;
import java.util.ArrayList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ReleaseMaterializationRebuildLocks
implements TransactionalFunction<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseMaterializationRebuildLocks.class);
    private final ValidTxnList validTxnList;
    private final long timeout;

    public ReleaseMaterializationRebuildLocks(ValidTxnList validTxnList, long timeout) {
        this.validTxnList = validTxnList;
        this.timeout = timeout;
    }

    @Override
    public Long execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        long cnt = 0L;
        ArrayList txnIds = new ArrayList();
        long timeoutTime = Instant.now().toEpochMilli() - this.timeout;
        String selectQ = "SELECT \"MRL_TXN_ID\", \"MRL_LAST_HEARTBEAT\" FROM \"MATERIALIZATION_REBUILD_LOCKS\"";
        LOG.debug("Going to execute query <{}>", (Object)selectQ);
        jdbcResource.getJdbcTemplate().query(selectQ, rs -> {
            long txnId;
            long lastHeartbeat;
            if (rs.next() && (lastHeartbeat = rs.getLong(2)) < timeoutTime && (this.validTxnList.isTxnValid(txnId = rs.getLong(1)) || this.validTxnList.isTxnAborted(txnId))) {
                txnIds.add(txnId);
            }
            return null;
        });
        if (!txnIds.isEmpty()) {
            String deleteQ = "DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" IN(:txnIds)";
            LOG.debug("Going to execute update <{}>", (Object)deleteQ);
            cnt = jdbcResource.getJdbcTemplate().update(deleteQ, (SqlParameterSource)new MapSqlParameterSource().addValue("txnIds", txnIds));
        }
        LOG.debug("Going to commit");
        return cnt;
    }
}

