/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.HeartbeatTxnFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class HeartbeatTxnRangeFunction
implements TransactionalFunction<HeartbeatTxnRangeResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatTxnRangeFunction.class);
    private final HeartbeatTxnRangeRequest rqst;

    public HeartbeatTxnRangeFunction(HeartbeatTxnRangeRequest rqst) {
        this.rqst = rqst;
    }

    @Override
    public HeartbeatTxnRangeResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        HeartbeatTxnRangeResponse rsp = new HeartbeatTxnRangeResponse();
        HashSet<Long> nosuch = new HashSet<Long>();
        HashSet<Long> aborted = new HashSet<Long>();
        rsp.setNosuch(nosuch);
        rsp.setAborted(aborted);
        ArrayList<String> queries = new ArrayList<String>();
        int numTxnsToHeartbeat = (int)(this.rqst.getMax() - this.rqst.getMin() + 1L);
        ArrayList<Long> txnIds = new ArrayList<Long>(numTxnsToHeartbeat);
        for (long txn = this.rqst.getMin(); txn <= this.rqst.getMax(); ++txn) {
            txnIds.add(txn);
        }
        TransactionContext context = jdbcResource.getTransactionManager().getActiveTransaction();
        Object savePoint = context.createSavepoint();
        TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, new StringBuilder("UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + " WHERE \"TXN_STATE\" = " + String.valueOf((Object)TxnStatus.OPEN) + " AND "), new StringBuilder(""), txnIds, "\"TXN_ID\"", true, false);
        int updateCnt = 0;
        for (String query : queries) {
            LOG.debug("Going to execute update <{}>", (Object)query);
            updateCnt += jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource());
        }
        if (updateCnt == numTxnsToHeartbeat) {
            context.createSavepoint();
            return rsp;
        }
        context.rollbackToSavepoint(savePoint);
        for (long txn = this.rqst.getMin(); txn <= this.rqst.getMax(); ++txn) {
            try {
                new HeartbeatTxnFunction(txn).execute(jdbcResource);
                continue;
            }
            catch (NoSuchTxnException e) {
                nosuch.add(txn);
                continue;
            }
            catch (TxnAbortedException e) {
                aborted.add(txn);
                continue;
            }
            catch (NoSuchLockException e) {
                throw new RuntimeException(e);
            }
        }
        return rsp;
    }
}

