/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.MinUncommittedTxnIdHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CleanTxnToWriteIdTableFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CleanTxnToWriteIdTableFunction.class);
    private final long minTxnIdSeenOpen;

    public CleanTxnToWriteIdTableFunction(long minTxnIdSeenOpen) {
        this.minTxnIdSeenOpen = minTxnIdSeenOpen;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        Long minTxnId = jdbcResource.execute(new MinUncommittedTxnIdHandler());
        if (minTxnId == null) {
            throw new MetaException("Transaction tables not properly initialized, no record found in TXNS");
        }
        long minUncommitedTxnid = Math.min(minTxnId, this.minTxnIdSeenOpen);
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        int rc = jdbcTemplate.update("DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" < :txnId", (SqlParameterSource)new MapSqlParameterSource("txnId", (Object)minUncommitedTxnid));
        LOG.info("Removed {} rows from TXN_TO_WRITE_ID with Txn Low-Water-Mark: {}", (Object)rc, (Object)minUncommitedTxnid);
        return null;
    }
}

