/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.jdbc.ConditionalCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContextManager;
import org.apache.hadoop.hive.metastore.utils.StackThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class MultiDataSourceJdbcResource {
    private static final Logger LOG = LoggerFactory.getLogger(MultiDataSourceJdbcResource.class);
    private final StackThreadLocal<String> threadLocal = new StackThreadLocal();
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private final Map<String, TransactionContextManager> transactionManagers = new HashMap<String, TransactionContextManager>();
    private final Map<String, NamedParameterJdbcTemplate> jdbcTemplates = new HashMap<String, NamedParameterJdbcTemplate>();
    private final DatabaseProduct databaseProduct;
    private final Configuration conf;
    private final SQLGenerator sqlGenerator;

    public MultiDataSourceJdbcResource(DatabaseProduct databaseProduct, Configuration conf, SQLGenerator sqlGenerator) {
        this.databaseProduct = databaseProduct;
        this.conf = conf;
        this.sqlGenerator = sqlGenerator;
    }

    public void registerDataSource(String dataSourceName, DataSource dataSource) {
        this.dataSources.put(dataSourceName, dataSource);
        this.jdbcTemplates.put(dataSourceName, new NamedParameterJdbcTemplate(dataSource));
        this.transactionManagers.put(dataSourceName, new TransactionContextManager((PlatformTransactionManager)new DataSourceTransactionManager(dataSource)));
    }

    public void bindDataSource(String dataSourceName) {
        this.threadLocal.set(dataSourceName);
    }

    public void bindDataSource(Transactional transactional) {
        this.threadLocal.set(transactional.value());
    }

    public void unbindDataSource() {
        this.threadLocal.unset();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public SQLGenerator getSqlGenerator() {
        return this.sqlGenerator;
    }

    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplates.get(this.getDataSourceName());
    }

    public Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.dataSources.get(this.getDataSourceName()));
    }

    public TransactionContextManager getTransactionManager() {
        return this.transactionManagers.get(this.getDataSourceName());
    }

    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public int execute(ParameterizedCommand command) throws MetaException {
        if (!this.shouldExecute(command)) {
            return -1;
        }
        try {
            return this.execute(command.getParameterizedQueryString(this.getDatabaseProduct()), command.getQueryParameters(), command.resultPolicy());
        }
        catch (Exception e) {
            this.handleError(command, e);
            throw e;
        }
    }

    public <T> int[][] execute(ParameterizedBatchCommand<T> command) throws MetaException {
        if (!this.shouldExecute(command)) {
            return null;
        }
        try {
            int maxBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
            return this.getJdbcTemplate().getJdbcTemplate().batchUpdate(command.getParameterizedQueryString(this.databaseProduct), command.getQueryParameters(), maxBatchSize, command.getPreparedStatementSetter());
        }
        catch (Exception e) {
            this.handleError(command, e);
            throw e;
        }
    }

    public <T> int execute(InClauseBatchCommand<T> command) throws MetaException {
        if (!this.shouldExecute(command)) {
            return -1;
        }
        try {
            List elements;
            if (StringUtils.isBlank((CharSequence)command.getInClauseParameterName())) {
                throw new MetaException("The IN() clause parameter name (InClauseBatchCommand.getInClauseParameterName() cannot be blank!");
            }
            try {
                elements = (List)command.getQueryParameters().getValue(command.getInClauseParameterName());
            }
            catch (ClassCastException e) {
                throw new MetaException("The parameter " + command.getInClauseParameterName() + "must be of type List<T>!");
            }
            MapSqlParameterSource params = (MapSqlParameterSource)command.getQueryParameters();
            String query = command.getParameterizedQueryString(this.databaseProduct);
            if (CollectionUtils.isEmpty((Collection)elements)) {
                throw new IllegalArgumentException("The elements list cannot be null or empty! An empty IN clause is invalid!");
            }
            if (!Pattern.compile("IN\\s*\\(\\s*:" + command.getInClauseParameterName() + "\\s*\\)", 2).matcher(query).find()) {
                throw new IllegalArgumentException("The query must contain the IN(:" + command.getInClauseParameterName() + ") clause!");
            }
            int maxQueryLength = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH) * 1024;
            int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE);
            int elementLength = elements.isEmpty() ? 1 : elements.stream().max(command.getParameterLengthComparator()).orElseThrow(IllegalStateException::new).toString().length() + 2;
            int baseQueryLength = query.length();
            int maxElementsByLength = (maxQueryLength - baseQueryLength) / elementLength;
            int inClauseMaxSize = Math.min(batchSize, maxElementsByLength);
            int fromIndex = 0;
            int totalCount = 0;
            while (fromIndex < elements.size()) {
                int endIndex = Math.min(elements.size(), fromIndex + inClauseMaxSize);
                params.addValue(command.getInClauseParameterName(), elements.subList(fromIndex, endIndex));
                totalCount += this.getJdbcTemplate().update(query, (SqlParameterSource)params);
                fromIndex = endIndex;
            }
            return totalCount;
        }
        catch (Exception e) {
            this.handleError(command, e);
            throw e;
        }
    }

    public int execute(String query, SqlParameterSource params, Function<Integer, Boolean> resultPolicy) throws MetaException {
        LOG.debug("Going to execute command <{}>", (Object)query);
        int count = this.getJdbcTemplate().update(query, params);
        if (resultPolicy != null && !resultPolicy.apply(count).booleanValue()) {
            LOG.error("The update count was " + count + " which is not the expected. Rolling back.");
            throw new MetaException("The update count was " + count + " which is not the expected. Rolling back.");
        }
        LOG.debug("Command <{}> updated {} records.", (Object)query, (Object)count);
        return count;
    }

    public <T> T execute(QueryHandler<T> queryHandler) throws MetaException {
        String queryStr = queryHandler.getParameterizedQueryString(this.getDatabaseProduct());
        LOG.debug("Going to execute query <{}>", (Object)queryStr);
        SqlParameterSource params = queryHandler.getQueryParameters();
        if (params != null) {
            return (T)this.getJdbcTemplate().query(queryStr, params, queryHandler);
        }
        return (T)this.getJdbcTemplate().query(queryStr, queryHandler);
    }

    private String getDataSourceName() {
        return this.threadLocal.get();
    }

    private boolean shouldExecute(Object command) {
        return !(command instanceof ConditionalCommand) || ((ConditionalCommand)command).shouldBeUsed(this.databaseProduct);
    }

    private void handleError(Object command, Exception e) {
        if (command instanceof ConditionalCommand) {
            ((ConditionalCommand)command).onError(this.databaseProduct, e);
        }
    }
}

