/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MetaToolTaskDiffExtTblLocs
extends MetaToolTask {
    @Override
    void execute() {
        String[] args = this.getCl().getDiffExtTblLocsParams();
        try {
            File file1 = new File(args[0]);
            File file2 = new File(args[1]);
            String ouputDir = args[2];
            String outFileName = "diff_" + System.currentTimeMillis();
            System.out.println("Writing diff to " + outFileName);
            if (!file1.exists()) {
                System.out.println("Input " + args[0] + " does not exist.");
                return;
            }
            if (!file2.exists()) {
                System.out.println("Input " + args[1] + " does not exist.");
                return;
            }
            JSONObject jsonObject = this.getDiffJson(file1, file2);
            FileWriter fw = new FileWriter(ouputDir + "/" + outFileName);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(jsonObject.toString(4).replace("\\", ""));
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Generating diff failed: \n" + e.getMessage());
        }
    }

    private JSONObject getDiffJson(File file1, File file2) throws IOException, JSONException {
        JSONObject inJson1 = new JSONObject(new String(Files.readAllBytes(Paths.get(file1.getAbsolutePath(), new String[0]))));
        JSONObject inJson2 = new JSONObject(new String(Files.readAllBytes(Paths.get(file2.getAbsolutePath(), new String[0]))));
        HashMap modifiedLocations = new HashMap();
        Set<String> keySet1 = this.getKeySet(inJson1);
        Set<String> keySet2 = this.getKeySet(inJson2);
        Set<String> uniqueLocationsFile1 = this.getSetDifference(keySet1, keySet2);
        Set<String> uniqueLocationsFile2 = this.getSetDifference(keySet2, keySet1);
        for (String loc : keySet1) {
            int j;
            int i;
            if (uniqueLocationsFile1.contains(loc)) continue;
            JSONArray valArr1 = inJson1.getJSONArray(loc);
            JSONArray valArr2 = inJson2.getJSONArray(loc);
            for (i = 0; i < valArr1.length(); ++i) {
                String val1 = valArr1.getString(i);
                boolean absentFromSecondKey = true;
                for (j = 0; j < valArr2.length(); ++j) {
                    String val2 = valArr2.getString(j);
                    if (!val1.equalsIgnoreCase(val2)) continue;
                    absentFromSecondKey = false;
                    break;
                }
                if (!absentFromSecondKey) continue;
                if (modifiedLocations.containsKey(loc)) {
                    ((HashSet)modifiedLocations.get(loc)).add(this.asDeleted(val1));
                    continue;
                }
                modifiedLocations.put(loc, new HashSet());
                ((HashSet)modifiedLocations.get(loc)).add(this.asDeleted(val1));
            }
            for (i = 0; i < valArr2.length(); ++i) {
                String val2 = valArr2.getString(i);
                boolean absentFromFirstKey = true;
                for (j = 0; j < valArr1.length(); ++j) {
                    String val1 = valArr1.getString(j);
                    if (!val1.equalsIgnoreCase(val2)) continue;
                    absentFromFirstKey = false;
                    break;
                }
                if (!absentFromFirstKey) continue;
                if (modifiedLocations.containsKey(loc)) {
                    ((HashSet)modifiedLocations.get(loc)).add(this.asAdded(val2));
                    continue;
                }
                modifiedLocations.put(loc, new HashSet());
                ((HashSet)modifiedLocations.get(loc)).add(this.asAdded(val2));
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (!uniqueLocationsFile1.isEmpty() || !uniqueLocationsFile2.isEmpty()) {
            jsonObject.put("Locations only in " + file1.getName(), uniqueLocationsFile1);
            jsonObject.put("Locations only in " + file2.getName(), uniqueLocationsFile2);
        }
        for (String commonLoc : modifiedLocations.keySet()) {
            ArrayList<String> modifiedEntries = new ArrayList<String>();
            for (String entry : (HashSet)modifiedLocations.get(commonLoc)) {
                modifiedEntries.add(entry);
            }
            Collections.sort(modifiedEntries);
            jsonObject.put(commonLoc, modifiedEntries);
        }
        return jsonObject;
    }

    private Set<String> getKeySet(JSONObject jsonObject) {
        Iterator keyIter = jsonObject.keys();
        HashSet<String> keySet = new HashSet<String>();
        while (keyIter.hasNext()) {
            keySet.add((String)keyIter.next());
        }
        return keySet;
    }

    private Set<String> getSetDifference(Set<String> keySet1, Set<String> keySet2) {
        HashSet<String> diffSet = new HashSet<String>();
        for (String elem : keySet1) {
            if (keySet2.contains(elem)) continue;
            diffSet.add(elem);
        }
        return diffSet;
    }

    private String asDeleted(String str) {
        return "- " + str;
    }

    private String asAdded(String str) {
        return "+ " + str;
    }
}

