/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnStatsMerger<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnStatsMerger.class);

    public abstract void merge(ColumnStatisticsObj var1, ColumnStatisticsObj var2);

    protected KllHistogramEstimator mergeHistogramEstimator(String columnName, KllHistogramEstimator oldEst, KllHistogramEstimator newEst) {
        if (oldEst != null && newEst != null) {
            if (oldEst.canMerge(newEst)) {
                LOG.trace("Merging old sketch {} with new sketch {}...", (Object)oldEst.getSketch(), (Object)newEst.getSketch());
                oldEst.mergeEstimators(newEst);
                LOG.trace("Resulting sketch is {}", (Object)oldEst.getSketch());
                return oldEst;
            }
            LOG.debug("Merging histograms of column {}", (Object)columnName);
        } else if (newEst != null) {
            LOG.trace("Old sketch is empty, the new sketch is used {}", (Object)newEst.getSketch());
            return newEst;
        }
        return oldEst;
    }

    protected long mergeNumDistinctValueEstimator(String columnName, List<NumDistinctValueEstimator> estimators, long oldNumDVs, long newNumDVs) {
        if (estimators == null || estimators.size() != 2) {
            throw new IllegalArgumentException("NDV estimators list must be set and contain exactly two elements, found " + (estimators == null ? "null" : estimators.stream().map((Function<NumDistinctValueEstimator, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/apache/hadoop/hive/common/ndv/NumDistinctValueEstimator;)Ljava/lang/String;)()).collect(Collectors.joining(", "))));
        }
        NumDistinctValueEstimator oldEst = estimators.get(0);
        NumDistinctValueEstimator newEst = estimators.get(1);
        if (oldEst == null && newEst == null) {
            return this.mergeNumDVs(oldNumDVs, newNumDVs);
        }
        if (oldEst == null) {
            estimators.set(0, newEst);
            return this.mergeNumDVs(oldNumDVs, newEst.estimateNumDistinctValues());
        }
        if (oldEst.canMerge(newEst)) {
            oldEst.mergeEstimators(newEst);
            long ndv = oldEst.estimateNumDistinctValues();
            return ndv;
        }
        long ndv = this.mergeNumDVs(oldNumDVs, newNumDVs);
        LOG.debug("Use bitvector to merge column {}'s ndvs of {} and {} to be {}", new Object[]{columnName, oldNumDVs, newNumDVs, ndv});
        return ndv;
    }

    public T mergeLowValue(T oldValue, T newValue) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public T mergeHighValue(T oldValue, T newValue) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public long mergeNumDVs(long oldValue, long newValue) {
        return Math.max(oldValue, newValue);
    }

    public long mergeNumNulls(long oldValue, long newValue) {
        return oldValue + newValue;
    }

    public long mergeMaxColLen(long oldValue, long newValue) {
        return Math.max(oldValue, newValue);
    }

    public double mergeAvgColLen(double oldValue, double newValue) {
        return Math.max(oldValue, newValue);
    }
}

