/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.oauth2;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.auth.oauth2.JWTAccessTokenAuthenticator;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2Authenticator;
import org.apache.hadoop.hive.metastore.auth.oauth2.RegexOAuth2PrincipalMapper;
import org.apache.hadoop.hive.metastore.auth.oauth2.TokenIntrospectionAuthenticator;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public final class OAuth2AuthenticatorFactory {
    private OAuth2AuthenticatorFactory() {
        throw new AssertionError();
    }

    public static OAuth2Authenticator createAuthenticator(Configuration conf) throws IOException {
        String validation;
        AuthorizationServerMetadata metadata;
        Issuer issuer = Issuer.parse((String)MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_ISSUER));
        Objects.requireNonNull(issuer);
        String audience = MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_AUDIENCE);
        try {
            metadata = AuthorizationServerMetadata.resolve((Issuer)issuer);
        }
        catch (GeneralException e) {
            throw new IOException("Failed to resolve the authorization server metadata. " + "Please check %s/.well-known/oauth-authorization-server is available".formatted(issuer), e);
        }
        String claim = MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_PRINCIPAL_MAPPER_REGEX_FIELD);
        Pattern pattern = Pattern.compile(MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_PRINCIPAL_MAPPER_REGEX_PATTERN));
        RegexOAuth2PrincipalMapper principalMapper = new RegexOAuth2PrincipalMapper(claim, pattern);
        switch (validation = MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_VALIDATION_METHOD)) {
            case "jwt": {
                if (metadata.getJWKSetURI() == null) {
                    throw new IllegalStateException(".well-known/oauth-authorization-server does not include jwks_uri");
                }
                return new JWTAccessTokenAuthenticator(issuer, metadata.getJWKSetURI().toURL(), audience, principalMapper);
            }
            case "introspection": {
                if (metadata.getIntrospectionEndpointURI() == null) {
                    throw new IllegalStateException(".well-known/oauth-authorization-server does not include introspection_endpoint");
                }
                String clientId = MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_CLIENT_ID);
                String clientSecret = MetastoreConf.getPassword((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_CLIENT_SECRET);
                ClientSecretBasic credential = new ClientSecretBasic(new ClientID(clientId), new Secret(clientSecret));
                Duration cacheExpiry = Duration.ofSeconds(MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_INTROSPECTION_CACHE_EXPIRY, (TimeUnit)TimeUnit.SECONDS));
                long cacheSize = MetastoreConf.getLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH_OAUTH2_INTROSPECTION_CACHE_SIZE);
                return new TokenIntrospectionAuthenticator(metadata.getIntrospectionEndpointURI(), new Audience(audience), (ClientAuthentication)credential, principalMapper, cacheExpiry, cacheSize);
            }
        }
        throw new IllegalArgumentException("Illegal validation method: " + validation);
    }
}

