/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class TableFields {
    private static final ImmutableMap<String, String> allSingleValuedFields = new ImmutableMap.Builder().put((Object)"id", (Object)"id").put((Object)"tableName", (Object)"tableName").put((Object)"dbName", (Object)"database.name").put((Object)"owner", (Object)"owner").put((Object)"ownerType", (Object)"ownerType").put((Object)"createTime", (Object)"createTime").put((Object)"lastAccessTime", (Object)"lastAccessTime").put((Object)"retention", (Object)"retention").put((Object)"sd.location", (Object)"sd.location").put((Object)"sd.inputFormat", (Object)"sd.inputFormat").put((Object)"sd.outputFormat", (Object)"sd.outputFormat").put((Object)"sd.compressed", (Object)"sd.isCompressed").put((Object)"sd.numBuckets", (Object)"sd.numBuckets").put((Object)"sd.serdeInfo.name", (Object)"sd.serDeInfo.name").put((Object)"sd.serdeInfo.serializationLib", (Object)"sd.serDeInfo.serializationLib").put((Object)"sd.serdeInfo.description", (Object)"sd.serDeInfo.description").put((Object)"sd.serdeInfo.serializerClass", (Object)"sd.serDeInfo.serializerClass").put((Object)"sd.serdeInfo.deserializerClass", (Object)"sd.serDeInfo.deserializerClass").put((Object)"sd.serdeInfo.serdeType", (Object)"sd.serDeInfo.serdeType").put((Object)"sd.storedAsSubDirectories", (Object)"isStoredAsSubDirectories").put((Object)"viewOriginalText", (Object)"viewOriginalText").put((Object)"viewExpandedText", (Object)"viewExpandedText").put((Object)"rewriteEnabled", (Object)"rewriteEnabled").put((Object)"tableType", (Object)"tableType").put((Object)"writeId", (Object)"writeId").build();
    private static final ImmutableSet<String> allMultiValuedFields = new ImmutableSet.Builder().add((Object)"values").add((Object)"sd.cols.name").add((Object)"sd.cols.type").add((Object)"sd.cols.comment").add((Object)"sd.serdeInfo.parameters").add((Object)"sd.bucketCols").add((Object)"sd.sortCols.col").add((Object)"sd.sortCols.order").add((Object)"sd.parameters").add((Object)"sd.skewedInfo.skewedColNames").add((Object)"sd.skewedInfo.skewedColValues").add((Object)"sd.skewedInfo.skewedColValueLocationMaps").add((Object)"partitionKeys.name").add((Object)"partitionKeys.type").add((Object)"partitionKeys.comment").add((Object)"parameters").build();
    private static final ImmutableSet<String> allFields = new ImmutableSet.Builder().addAll((Iterable)allSingleValuedFields.keySet()).addAll(allMultiValuedFields).build();

    private static void validate(Collection<String> projectionFields) throws MetaException {
        HashSet<String> verify = new HashSet<String>(projectionFields);
        verify.removeAll((Collection<?>)allFields);
        if (verify.size() > 0) {
            throw new MetaException("Invalid table fields in the projection spec" + Arrays.toString(verify.toArray(new String[verify.size()])));
        }
    }

    public static List<String> getMFieldNames(List<String> fields) throws MetaException {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        TableFields.validate(fields);
        if (!allSingleValuedFields.keySet().containsAll(fields)) {
            return null;
        }
        ArrayList<String> jdoFields = new ArrayList<String>(fields.size());
        for (String field : fields) {
            jdoFields.add((String)allSingleValuedFields.get((Object)field));
        }
        return jdoFields;
    }
}

