/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInfoCache {
    private static final Logger LOG = LoggerFactory.getLogger(QueryInfoCache.class);
    private Object webuiLock = new Object();
    private HistoricalQueryInfos historicalQueryInfos;
    private Map<String, QueryInfo> liveQueryInfos = new LinkedHashMap<String, QueryInfo>();

    QueryInfoCache(HiveConf hiveConf) {
        if (hiveConf.isWebUiQueryInfoCacheEnabled()) {
            this.historicalQueryInfos = new HistoricalQueryInfos(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_MAX_HISTORIC_QUERIES));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveQueryInfo(Operation operation) {
        if (operation instanceof SQLOperation) {
            Object object = this.webuiLock;
            synchronized (object) {
                this.liveQueryInfos.put(operation.getHandle().getHandleIdentifier().toString(), ((SQLOperation)operation).getQueryInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryInfo> getLiveQueryInfos() {
        LinkedList<QueryInfo> result = new LinkedList<QueryInfo>();
        Object object = this.webuiLock;
        synchronized (object) {
            result.addAll(this.liveQueryInfos.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveQueryInfo(Operation operation) {
        if (operation instanceof SQLOperation) {
            OperationHandle operationHandle = operation.getHandle();
            Object object = this.webuiLock;
            synchronized (object) {
                String opKey = operationHandle.getHandleIdentifier().toString();
                QueryInfo display = this.liveQueryInfos.remove(opKey);
                if (display == null) {
                    LOG.debug("Unexpected display object value of null for operation {}", (Object)opKey);
                } else if (this.historicalQueryInfos != null) {
                    this.historicalQueryInfos.put(opKey, display);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryInfo getQueryInfo(String handle) {
        Object object = this.webuiLock;
        synchronized (object) {
            QueryInfo result = this.liveQueryInfos.get(handle);
            if (result != null) {
                return result;
            }
            if (this.historicalQueryInfos == null) {
                return null;
            }
            return (QueryInfo)this.historicalQueryInfos.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryInfo> getHistoricalQueryInfos() {
        LinkedList<QueryInfo> result = new LinkedList<QueryInfo>();
        Object object = this.webuiLock;
        synchronized (object) {
            if (this.historicalQueryInfos != null) {
                result.addAll(this.historicalQueryInfos.values());
                Collections.reverse(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllQueryIds() {
        LinkedList<Object> queryInfos = new LinkedList<Object>();
        Object object = this.webuiLock;
        synchronized (object) {
            queryInfos.addAll(this.liveQueryInfos.values());
            if (this.historicalQueryInfos != null) {
                queryInfos.addAll(this.historicalQueryInfos.values());
            }
        }
        HashSet<String> results = new HashSet<String>();
        for (QueryInfo queryInfo : queryInfos) {
            results.add(queryInfo.getQueryDisplay().getQueryId());
        }
        return results;
    }

    private static class HistoricalQueryInfos
    extends LinkedHashMap<String, QueryInfo> {
        private final int capacity;

        public HistoricalQueryInfos(int capacity) {
            super(capacity + 1, 1.1f, false);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }
}

