/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.service.auth.saml.HiveSamlRelayStateInfo;
import org.apache.hive.service.auth.saml.HttpSamlAuthenticationException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.generator.ValueGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlRelayStateStore
implements ValueGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSamlRelayStateStore.class);
    private final Cache<String, HiveSamlRelayStateInfo> relayStateCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final HiveSamlRelayStateStore INSTANCE = new HiveSamlRelayStateStore();

    private HiveSamlRelayStateStore() {
    }

    public static HiveSamlRelayStateStore get() {
        return INSTANCE;
    }

    public String generateValue(WebContext webContext) {
        Optional portNumber = webContext.getRequestHeader("X-Hive-Token-Response-Port");
        if (!portNumber.isPresent()) {
            throw new RuntimeException("SAML response port header X-Hive-Token-Response-Port is not set ");
        }
        int port = Integer.parseInt((String)portNumber.get());
        String relayState = UUID.randomUUID().toString();
        HiveSamlRelayStateInfo relayStateInfo = new HiveSamlRelayStateInfo(port, UUID.randomUUID().toString());
        webContext.setResponseHeader("X-Hive-Client-Identifier", relayStateInfo.getClientIdentifier());
        this.relayStateCache.put((Object)relayState, (Object)relayStateInfo);
        return relayState;
    }

    public String getRelayStateInfo(HttpServletRequest request, HttpServletResponse response) throws HttpSamlAuthenticationException {
        String relayState = request.getParameter("RelayState");
        if (relayState == null) {
            throw new HttpSamlAuthenticationException("Could not get the RelayState from the SAML response");
        }
        return relayState;
    }

    public HiveSamlRelayStateInfo getRelayStateInfo(String relayStateId) throws HttpSamlAuthenticationException {
        HiveSamlRelayStateInfo relayStateInfo = (HiveSamlRelayStateInfo)this.relayStateCache.getIfPresent((Object)relayStateId);
        if (relayStateInfo == null) {
            throw new HttpSamlAuthenticationException("Invalid value of relay state received: " + relayStateId);
        }
        return relayStateInfo;
    }

    public synchronized boolean validateClientIdentifier(String relayStateKey, String clientIdentifier) {
        HiveSamlRelayStateInfo relayStateInfo = (HiveSamlRelayStateInfo)this.relayStateCache.getIfPresent((Object)relayStateKey);
        if (relayStateInfo == null) {
            return false;
        }
        this.relayStateCache.invalidate((Object)relayStateKey);
        LOG.debug("Validating client identifier {} with {}", (Object)clientIdentifier, (Object)relayStateInfo.getClientIdentifier());
        return String.valueOf(relayStateInfo.getClientIdentifier()).equals(clientIdentifier);
    }
}

