/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);

    private ServiceOperations() {
    }

    public static void ensureCurrentState(Service.STATE state, Service.STATE expectedState) {
        if (state != expectedState) {
            throw new IllegalStateException("For this operation, the current service state must be " + String.valueOf((Object)expectedState) + " instead of " + String.valueOf((Object)state));
        }
    }

    public static void init(Service service, HiveConf configuration) {
        Service.STATE state = service.getServiceState();
        ServiceOperations.ensureCurrentState(state, Service.STATE.NOTINITED);
        service.init(configuration);
    }

    public static void start(Service service) {
        Service.STATE state = service.getServiceState();
        ServiceOperations.ensureCurrentState(state, Service.STATE.INITED);
        service.start();
    }

    public static void deploy(Service service, HiveConf configuration) {
        ServiceOperations.init(service, configuration);
        ServiceOperations.start(service);
    }

    public static void stop(Service service) {
        Service.STATE state;
        if (service != null && (state = service.getServiceState()) == Service.STATE.STARTED) {
            service.stop();
        }
    }

    public static Exception stopQuietly(Service service) {
        try {
            ServiceOperations.stop(service);
        }
        catch (Exception e) {
            LOG.warn("When stopping the service " + service.getName() + " : " + String.valueOf(e), (Throwable)e);
            return e;
        }
        return null;
    }
}

