/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestRow {
    @Test
    public void testUsage() {
        Schema schema = this.createTestSchema();
        Row row = new Row(schema);
        Random rand = new Random();
        int iterations = 100;
        for (int idx = 0; idx < iterations; ++idx) {
            boolean isNullCol0 = rand.nextDouble() <= 0.25;
            String col0 = RandomStringUtils.random((int)10);
            row.setValue(0, (Object)(isNullCol0 ? null : col0));
            boolean isNullCol1 = rand.nextDouble() <= 0.25;
            Integer col1 = rand.nextInt();
            row.setValue(1, (Object)(isNullCol1 ? null : col1));
            if (isNullCol0) {
                Assert.assertTrue((row.getValue(0) == null ? 1 : 0) != 0);
                Assert.assertTrue((row.getValue("col0") == null ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((row.getValue(0) != null ? 1 : 0) != 0);
                Assert.assertEquals((Object)col0, (Object)row.getValue(0));
                Assert.assertEquals((Object)col0, (Object)row.getValue("col0"));
            }
            if (isNullCol1) {
                Assert.assertTrue((row.getValue(1) == null ? 1 : 0) != 0);
                Assert.assertTrue((row.getValue("col1") == null ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((row.getValue(1) != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)col1, (Object)row.getValue(1));
            Assert.assertEquals((Object)col1, (Object)row.getValue("col1"));
        }
    }

    private Schema createTestSchema() {
        ArrayList<FieldDesc> colDescs = new ArrayList<FieldDesc>();
        colDescs.add(new FieldDesc("col0", (TypeInfo)TypeInfoFactory.stringTypeInfo));
        colDescs.add(new FieldDesc("col1", (TypeInfo)TypeInfoFactory.intTypeInfo));
        Schema schema = new Schema(colDescs);
        return schema;
    }
}

