/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.ICSVParser;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractEncodingAwareSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "serialization.encoding", "separatorChar", "quoteChar", "escapeChar", "applyQuotesToAll"})
public final class OpenCSVSerde
extends AbstractEncodingAwareSerDe {
    private ObjectInspector inspector;
    private String[] outputFields;
    private int numCols;
    private List<String> row;
    private char separatorChar;
    private char quoteChar;
    private char escapeChar;
    private boolean applyQuotesToAll;
    public static final String SEPARATORCHAR = "separatorChar";
    public static final String QUOTECHAR = "quoteChar";
    public static final String ESCAPECHAR = "escapeChar";
    public static final String APPLYQUOTESTOALL = "applyQuotesToAll";

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        int i;
        super.initialize(configuration, tableProperties, partitionProperties);
        this.numCols = this.getColumnNames().size();
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.numCols);
        for (i = 0; i < this.numCols; ++i) {
            columnOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.getColumnNames(), columnOIs);
        this.outputFields = new String[this.numCols];
        this.row = new ArrayList<String>(this.numCols);
        for (i = 0; i < this.numCols; ++i) {
            this.row.add(null);
        }
        this.separatorChar = this.getProperty(this.properties, SEPARATORCHAR, ',');
        this.quoteChar = this.getProperty(this.properties, QUOTECHAR, '\"');
        this.escapeChar = this.getProperty(this.properties, ESCAPECHAR, '\"');
        this.applyQuotesToAll = Boolean.parseBoolean(this.properties.getProperty(APPLYQUOTESTOALL, "true"));
    }

    private char getProperty(Properties tbl, String property, char def) {
        String val = tbl.getProperty(property);
        if (val != null) {
            return val.charAt(0);
        }
        return def;
    }

    @Override
    public Writable doSerialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        StructObjectInspector outputRowOI = (StructObjectInspector)objInspector;
        List<? extends StructField> outputFieldRefs = outputRowOI.getAllStructFieldRefs();
        if (outputFieldRefs.size() != this.numCols) {
            throw new SerDeException("Cannot serialize the object because there are " + outputFieldRefs.size() + " fields but the table has " + this.numCols + " columns.");
        }
        for (int c = 0; c < this.numCols; ++c) {
            Object field = outputRowOI.getStructFieldData(obj, outputFieldRefs.get(c));
            ObjectInspector fieldOI = outputFieldRefs.get(c).getFieldObjectInspector();
            if (fieldOI instanceof StringObjectInspector) {
                this.outputFields[c] = ((StringObjectInspector)fieldOI).getPrimitiveJavaObject(field);
                continue;
            }
            if (fieldOI instanceof AbstractPrimitiveWritableObjectInspector) {
                Object primitiveJavaObject = ((AbstractPrimitiveWritableObjectInspector)fieldOI).getPrimitiveJavaObject(field);
                this.outputFields[c] = Objects.toString(primitiveJavaObject, null);
                continue;
            }
            throw new UnsupportedOperationException("Column type of " + fieldOI.getTypeName() + " is not supported with OpenCSVSerde");
        }
        StringWriter writer = new StringWriter();
        CSVWriter csv = this.newWriter(writer, this.separatorChar, this.quoteChar, this.escapeChar);
        try {
            csv.writeNext(this.outputFields, this.applyQuotesToAll);
            csv.close();
            return new Text(writer.toString());
        }
        catch (IOException ioe) {
            throw new SerDeException(ioe);
        }
    }

    @Override
    public Object doDeserialize(Writable blob) throws SerDeException {
        Text rowText = (Text)blob;
        CSVReader csv = null;
        try {
            csv = this.newReader(new CharArrayReader(rowText.toString().toCharArray()), this.separatorChar, this.quoteChar, this.escapeChar);
            String[] read = csv.readNext();
            for (int i = 0; i < this.numCols; ++i) {
                if (read != null && i < read.length) {
                    this.row.set(i, read[i]);
                    continue;
                }
                this.row.set(i, null);
            }
            List<String> list = this.row;
            return list;
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
        finally {
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (Exception e) {
                    log.error("fail to close csv writer", (Throwable)e);
                }
            }
        }
    }

    private CSVReader newReader(Reader reader, char separator, char quote, char escape) {
        if ('\"' == escape) {
            return new CSVReaderBuilder(reader).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(separator).withQuoteChar(quote).build()).build();
        }
        return new CSVReaderBuilder(reader).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(separator).withQuoteChar(quote).withEscapeChar(escape).build()).build();
    }

    private CSVWriter newWriter(Writer writer, char separator, char quote, char escape) {
        if ('\"' == escape) {
            return new CSVWriter(writer, separator, quote, '\"', "");
        }
        return new CSVWriter(writer, separator, quote, escape, "");
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    protected Text transformFromUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextFromUTF8(text, this.charset);
    }

    protected Text transformToUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextToUTF8(text, this.charset);
    }
}

