/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractEncodingAwareSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "field.delim", "collection.delim", "mapkey.delim", "serialization.format", "serialization.null.format", "serialization.escape.crlf", "serialization.last.column.takes.rest", "escape.delim", "serialization.encoding", "hive.serialization.extend.nesting.levels", "hive.serialization.extend.additional.nesting.levels"})
public class MultiDelimitSerDe
extends AbstractEncodingAwareSerDe {
    private static final byte[] DEFAULT_SEPARATORS = new byte[]{1, 2, 3};
    public static final String REPLACEMENT_DELIM_SEQUENCE = "\u0001";
    public static final int REPLACEMENT_DELIM_LENGTH = "\u0001".getBytes().length;
    private int numColumns;
    private String fieldDelimited;
    private byte collSep;
    private byte keySep;
    private LazyStruct cachedLazyStruct;
    private ObjectInspector cachedObjectInspector;
    private ByteArrayRef byteArrayRef;
    private LazySerDeParameters serdeParams = null;
    private final ByteStream.Output serializeStream = new ByteStream.Output();
    private final Text serializeCache = new Text();

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.serdeParams = new LazySerDeParameters(configuration, tableProperties, this.getClass().getName());
        this.fieldDelimited = this.properties.getProperty("field.delim");
        if (this.fieldDelimited == null || this.fieldDelimited.isEmpty()) {
            throw new SerDeException("This table does not have serde property \"field.delim\"!");
        }
        this.collSep = LazyUtils.getByte(this.properties.getProperty("collection.delim"), DEFAULT_SEPARATORS[1]);
        this.keySep = LazyUtils.getByte(this.properties.getProperty("mapkey.delim"), DEFAULT_SEPARATORS[2]);
        this.serdeParams.setSeparator(1, this.collSep);
        this.serdeParams.setSeparator(2, this.keySep);
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector(this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes(), this.serdeParams.getSeparators(), this.serdeParams.getNullSequence(), this.serdeParams.isLastColumnTakesRest(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar());
        this.cachedLazyStruct = (LazyStruct)LazyFactory.createLazyObject(this.cachedObjectInspector);
        assert (this.serdeParams.getColumnNames().size() == this.serdeParams.getColumnTypes().size());
        this.numColumns = this.serdeParams.getColumnNames().size();
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Object doDeserialize(Writable blob) throws SerDeException {
        String rowStr;
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        if (blob instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)blob;
            rowStr = new String(b.getBytes());
        } else if (blob instanceof Text) {
            Text rowText = (Text)blob;
            rowStr = rowText.toString();
        } else {
            throw new SerDeException(String.valueOf(this.getClass()) + ": expects either BytesWritable or Text object!");
        }
        this.byteArrayRef.setData(rowStr.replaceAll(Pattern.quote(this.fieldDelimited), REPLACEMENT_DELIM_SEQUENCE).getBytes(StandardCharsets.UTF_8));
        this.cachedLazyStruct.init(this.byteArrayRef, 0, this.byteArrayRef.getData().length);
        this.cachedLazyStruct.parseMultiDelimit(rowStr.getBytes(StandardCharsets.UTF_8), this.fieldDelimited.getBytes(StandardCharsets.UTF_8));
        return this.cachedLazyStruct;
    }

    @Override
    public Writable doSerialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(obj);
        if (fields.size() != this.numColumns) {
            throw new SerDeException("Cannot serialize the object because there are " + fields.size() + " fields but the table has " + this.numColumns + " columns.");
        }
        this.serializeStream.reset();
        for (int c = 0; c < this.numColumns; ++c) {
            if (c > 0) {
                this.serializeStream.write(this.fieldDelimited.getBytes(), 0, this.fieldDelimited.getBytes().length);
            }
            Object field = list == null ? null : list.get(c);
            ObjectInspector fieldOI = fields.get(c).getFieldObjectInspector();
            try {
                MultiDelimitSerDe.serializeNoEncode(this.serializeStream, field, fieldOI, this.serdeParams.getSeparators(), 1, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                continue;
            }
            catch (IOException e) {
                throw new SerDeException(e);
            }
        }
        this.serializeCache.set(this.serializeStream.getData(), 0, this.serializeStream.getLength());
        return this.serializeCache;
    }

    private static void serializeNoEncode(ByteStream.Output out, Object obj, ObjectInspector objInspector, byte[] separators, int level, Text nullSequence, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException, SerDeException {
        if (obj == null) {
            out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
            return;
        }
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector oi = (PrimitiveObjectInspector)objInspector;
                if (oi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
                    BytesWritable bw = ((BinaryObjectInspector)oi).getPrimitiveWritableObject(obj);
                    byte[] toWrite = new byte[bw.getLength()];
                    System.arraycopy(bw.getBytes(), 0, toWrite, 0, bw.getLength());
                    out.write(toWrite, 0, toWrite.length);
                } else {
                    LazyUtils.writePrimitiveUTF8((OutputStream)((Object)out), obj, oi, escaped, escapeChar, needsEscape);
                }
                return;
            }
            case LIST: {
                char separator = (char)separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List<?> list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        MultiDelimitSerDe.serializeNoEncode(out, list.get(i), eoi, separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case MAP: {
                char separator = (char)separators[level];
                char keyValueSeparator = (char)separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                if (map == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    boolean first = true;
                    for (Map.Entry<?, ?> entry : map.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            out.write(separator);
                        }
                        MultiDelimitSerDe.serializeNoEncode(out, entry.getKey(), koi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                        out.write(keyValueSeparator);
                        MultiDelimitSerDe.serializeNoEncode(out, entry.getValue(), voi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case STRUCT: {
                char separator = (char)separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                List<Object> list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        MultiDelimitSerDe.serializeNoEncode(out, list.get(i), fields.get(i).getFieldObjectInspector(), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
        }
        throw new RuntimeException("Unknown category type: " + String.valueOf((Object)objInspector.getCategory()));
    }

    protected Text transformFromUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextFromUTF8(text, this.charset);
    }

    protected Text transformToUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextToUTF8(text, this.charset);
    }
}

