/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.Map;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.messaging.InsertMessage;

public class InsertReplicationTask
extends ReplicationTask {
    private final InsertMessage insertMessage;

    public InsertReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "INSERT");
        this.insertMessage = messageFactory.getDeserializer().getInsertMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return true;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        String dbName = this.insertMessage.getDB();
        String tableName = this.insertMessage.getTable();
        Map ptnDesc = this.insertMessage.getPartitionKeyValues();
        return Collections.singletonList(new ExportCommand(dbName, tableName, ptnDesc, this.srcStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, ptnDesc)), false, this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dbName = this.insertMessage.getDB();
        String tableName = this.insertMessage.getTable();
        Map ptnDesc = this.insertMessage.getPartitionKeyValues();
        return Collections.singletonList(new ImportCommand(ReplicationUtils.mapIfMapAvailable(dbName, (Function<String, String>)this.dbNameMapping), ReplicationUtils.mapIfMapAvailable(tableName, (Function<String, String>)this.tableNameMapping), ptnDesc, this.dstStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, ptnDesc)), false, this.event.getEventId()));
    }
}

