/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class ZonedDateTimeStringConverter
implements TypeConverter<ZonedDateTime, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = -2300431146181867887L;

    @Override
    public ZonedDateTime toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, ZonedDateTime.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(ZonedDateTime date) {
        return date != null ? date.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 19;
    }
}

