/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class OffsetDateTimeTimestampConverter
implements TypeConverter<OffsetDateTime, Timestamp> {
    private static final long serialVersionUID = 1020419574496380608L;

    @Override
    public OffsetDateTime toMemberType(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    @Override
    public Timestamp toDatastoreType(OffsetDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return new Timestamp(Date.from(datetime.atZoneSameInstant(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

