/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class OffsetDateTimeDateConverter
implements TypeConverter<OffsetDateTime, Date> {
    private static final long serialVersionUID = 800484212767523129L;

    @Override
    public OffsetDateTime toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    @Override
    public Date toDatastoreType(OffsetDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return Date.from(datetime.atZoneSameInstant(ZoneId.systemDefault()).toInstant());
    }
}

