/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalTimeSqlTimeConverter
implements TypeConverter<LocalTime, Time> {
    private static final long serialVersionUID = -792979141879966844L;

    @Override
    public LocalTime toMemberType(Time time) {
        if (time == null) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time.getTime()), ZoneId.systemDefault()).toLocalTime();
    }

    @Override
    public Time toDatastoreType(LocalTime time) {
        if (time == null) {
            return null;
        }
        return new Time(Date.from(time.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

