/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateTimeTimestampConverter
implements TypeConverter<LocalDateTime, Timestamp> {
    private static final long serialVersionUID = -4426520457647540543L;

    @Override
    public LocalDateTime toMemberType(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return LocalDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    @Override
    public Timestamp toDatastoreType(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return new Timestamp(Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

