/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateTimeDateConverter
implements TypeConverter<LocalDateTime, Date> {
    private static final long serialVersionUID = -2827944255601470964L;

    @Override
    public LocalDateTime toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    @Override
    public Date toDatastoreType(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

