/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SCOUtils {
    public static <T> T unwrapSCOField(DNStateManager ownerSM, int memberNumber, SCO<T> value) {
        if (value == null) {
            return null;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            AbstractMemberMetaData mmd = ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(memberNumber);
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("026030", IdentityUtils.getPersistableIdentityForId(ownerSM.getInternalObjectId()), mmd.getName()));
        }
        T unwrappedValue = value.getValue();
        ownerSM.replaceField(memberNumber, unwrappedValue);
        return unwrappedValue;
    }

    public static <T> SCO<T> wrapSCOField(DNStateManager ownerSM, AbstractMemberMetaData mmd, Class instantiatedType, T value, boolean replaceField) {
        Class requiredType;
        if (value != null && value instanceof SCO) {
            if (replaceField) {
                ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), value);
            }
            return (SCO)value;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        Class clazz = requiredType = value != null ? value.getClass() : instantiatedType;
        if ("declared".equalsIgnoreCase(ec.getNucleusContext().getConfiguration().getStringProperty("datanucleus.type.wrapper.basis"))) {
            requiredType = mmd.getType();
        }
        SCO<T> sco = ec.getTypeManager().createSCOWrapper(ownerSM, mmd, requiredType);
        if (replaceField) {
            ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), sco);
        }
        if (value != null) {
            sco.initialise(value);
        } else {
            sco.initialise();
        }
        return sco;
    }

    public static Object wrapSCOField(DNStateManager ownerSM, int memberNumber, Object value, boolean replaceFieldIfChanged) {
        if (value == null || !ownerSM.getClassMetaData().getSCOMutableMemberFlags()[memberNumber]) {
            return value;
        }
        if (!(value instanceof SCO) || ownerSM.getObject() != ((SCO)value).getOwner()) {
            AbstractMemberMetaData mmd = ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(memberNumber);
            if (replaceFieldIfChanged && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026029", IdentityUtils.getPersistableIdentityForId(ownerSM.getInternalObjectId()), mmd.getName()));
            }
            ExecutionContext ec = ownerSM.getExecutionContext();
            if (value instanceof SCO) {
                if (replaceFieldIfChanged) {
                    ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), value);
                }
                return value;
            }
            Class requiredType = value.getClass();
            if ("declared".equalsIgnoreCase(ec.getNucleusContext().getConfiguration().getStringProperty("datanucleus.type.wrapper.basis"))) {
                requiredType = mmd.getType();
            }
            SCO<Object> sco = ec.getTypeManager().createSCOWrapper(ownerSM, mmd, requiredType);
            if (replaceFieldIfChanged) {
                ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), sco);
            }
            sco.initialise(value);
            return sco;
        }
        return value;
    }

    public static Object wrapAndReplaceSCOField(DNStateManager ownerSM, int memberNumber, Object newValue, Object oldValue, boolean replaceFieldIfChanged) {
        if (newValue == null || !ownerSM.getClassMetaData().getSCOMutableMemberFlags()[memberNumber]) {
            return newValue;
        }
        if (!(newValue instanceof SCO) || ownerSM.getObject() != ((SCO)newValue).getOwner()) {
            AbstractMemberMetaData mmd = ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(memberNumber);
            if (replaceFieldIfChanged && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026029", IdentityUtils.getPersistableIdentityForId(ownerSM.getInternalObjectId()), mmd.getName()));
            }
            if (newValue instanceof SCO) {
                if (replaceFieldIfChanged) {
                    ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), newValue);
                }
                return newValue;
            }
            Class<?> requiredType = newValue.getClass();
            SCO<?> sco = ownerSM.getExecutionContext().getTypeManager().createSCOWrapper(ownerSM, mmd, requiredType);
            if (replaceFieldIfChanged) {
                ownerSM.replaceField(mmd.getAbsoluteFieldNumber(), sco);
            }
            sco.initialise(newValue, oldValue);
            return sco;
        }
        return newValue;
    }

    public static String getContainerInfoMessage(DNStateManager ownerSM, String fieldName, SCOContainer cont, boolean useCache, boolean allowNulls, boolean lazyLoading) {
        String msg = Localiser.msg("023004", ownerSM.getObjectAsPrintable(), fieldName, cont.getClass().getName(), "[cache-values=" + useCache + ", lazy-loading=" + lazyLoading + ", allow-nulls=" + allowNulls + "]");
        return msg;
    }

    public static String getSCOWrapperOptionsMessage(boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        StringBuilder str = new StringBuilder();
        if (useCache) {
            str.append("cached");
        }
        if (lazyLoading) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("lazy-loaded");
        }
        if (queued) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("queued");
        }
        if (allowNulls) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("allowNulls");
        }
        return str.toString();
    }

    public static boolean allowNullsInContainer(boolean defaultValue, AbstractMemberMetaData mmd) {
        if (mmd.getContainer() == null) {
            return defaultValue;
        }
        if (Boolean.TRUE.equals(mmd.getContainer().allowNulls())) {
            return true;
        }
        if (Boolean.FALSE.equals(mmd.getContainer().allowNulls())) {
            return false;
        }
        return defaultValue;
    }

    public static boolean useContainerCache(DNStateManager ownerSM, AbstractMemberMetaData mmd) {
        if (ownerSM == null) {
            return false;
        }
        boolean useCache = ownerSM.getExecutionContext().getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.collections");
        if (ownerSM.getExecutionContext().getBooleanProperty("datanucleus.cache.collections") != null) {
            useCache = ownerSM.getExecutionContext().getBooleanProperty("datanucleus.cache.collections");
        }
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            useCache = true;
        } else if (mmd.getContainer() != null && mmd.getContainer().hasExtension("cache")) {
            useCache = Boolean.parseBoolean(mmd.getContainer().getValueForExtension("cache"));
        }
        return useCache;
    }

    public static boolean useCachedLazyLoading(DNStateManager ownerSM, AbstractMemberMetaData mmd) {
        if (ownerSM == null) {
            return false;
        }
        boolean lazy = false;
        AbstractClassMetaData cmd = ownerSM.getClassMetaData();
        Boolean lazyCollections = ownerSM.getExecutionContext().getNucleusContext().getConfiguration().getBooleanObjectProperty("datanucleus.cache.collections.lazy");
        if (lazyCollections != null) {
            lazy = lazyCollections;
        } else if (mmd.getContainer() != null && mmd.getContainer().hasExtension("cache-lazy-loading")) {
            lazy = Boolean.parseBoolean(mmd.getContainer().getValueForExtension("cache-lazy-loading"));
        } else {
            boolean inFP = false;
            int[] fpFields = ownerSM.getExecutionContext().getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
            int fieldNo = mmd.getAbsoluteFieldNumber();
            if (fpFields != null && fpFields.length > 0) {
                for (int i = 0; i < fpFields.length; ++i) {
                    if (fpFields[i] != fieldNo) continue;
                    inFP = true;
                    break;
                }
            }
            lazy = !inFP;
        }
        return lazy;
    }

    public static boolean collectionHasElementsWithoutIdentity(AbstractMemberMetaData mmd) {
        boolean elementsWithoutIdentity = false;
        if (mmd.isSerialized()) {
            elementsWithoutIdentity = true;
        } else if (mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null && mmd.getJoinMetaData() != null) {
            elementsWithoutIdentity = true;
        } else if (mmd.getCollection() != null && mmd.getCollection().isEmbeddedElement()) {
            elementsWithoutIdentity = true;
        }
        return elementsWithoutIdentity;
    }

    public static boolean mapHasKeysWithoutIdentity(AbstractMemberMetaData mmd) {
        boolean keysWithoutIdentity = false;
        if (mmd.isSerialized()) {
            keysWithoutIdentity = true;
        } else if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null && mmd.getJoinMetaData() != null) {
            keysWithoutIdentity = true;
        } else if (mmd.getMap() != null && mmd.getMap().isEmbeddedKey()) {
            keysWithoutIdentity = true;
        }
        return keysWithoutIdentity;
    }

    public static boolean mapHasValuesWithoutIdentity(AbstractMemberMetaData mmd) {
        boolean valuesWithoutIdentity = false;
        if (mmd.isSerialized()) {
            valuesWithoutIdentity = true;
        } else if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null && mmd.getJoinMetaData() != null) {
            valuesWithoutIdentity = true;
        } else if (mmd.getMap() != null && mmd.getMap().isEmbeddedValue()) {
            valuesWithoutIdentity = true;
        }
        return valuesWithoutIdentity;
    }

    public static boolean collectionHasSerialisedElements(AbstractMemberMetaData mmd) {
        boolean serialised = mmd.isSerialized();
        if (mmd.getCollection() != null && mmd.getCollection().isEmbeddedElement() && mmd.getJoinMetaData() == null) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean arrayIsStoredInSingleColumn(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        boolean singleColumn = mmd.isSerialized();
        if (!singleColumn && mmd.getArray() != null && mmd.getJoinMetaData() == null) {
            if (mmd.getArray().isEmbeddedElement()) {
                singleColumn = true;
            }
            Class<?> elementClass = mmd.getType().getComponentType();
            ApiAdapter api = mmgr.getApiAdapter();
            if (!elementClass.isInterface() && !api.isPersistable(elementClass)) {
                singleColumn = true;
            }
        }
        return singleColumn;
    }

    public static boolean mapHasSerialisedKeysAndValues(AbstractMemberMetaData mmd) {
        boolean inverseKeyField = false;
        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getMappedBy() != null) {
            inverseKeyField = true;
        }
        boolean inverseValueField = false;
        if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() != null) {
            inverseValueField = true;
        }
        boolean serialised = mmd.isSerialized();
        if (mmd.getMap() != null && mmd.getJoinMetaData() == null && mmd.getMap().isEmbeddedKey() && mmd.getMap().isEmbeddedValue() && !inverseKeyField && !inverseValueField) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean attachCopyElements(DNStateManager ownerSM, Collection scoColl, Collection detachedElements, boolean elementsWithoutId) {
        boolean contained;
        boolean updated = false;
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        Iterator scoCollIter = scoColl.iterator();
        while (scoCollIter.hasNext()) {
            Object currentElem = scoCollIter.next();
            Object currentElemId = api.getIdForObject(currentElem);
            Iterator desiredIter = detachedElements.iterator();
            contained = false;
            if (elementsWithoutId) {
                contained = detachedElements.contains(currentElem);
            } else {
                while (desiredIter.hasNext()) {
                    Object desiredElem = desiredIter.next();
                    if (currentElemId != null) {
                        if (!currentElemId.equals(api.getIdForObject(desiredElem))) continue;
                        contained = true;
                        break;
                    }
                    if (currentElem != desiredElem) continue;
                    contained = true;
                    break;
                }
            }
            if (contained) continue;
            scoCollIter.remove();
            updated = true;
        }
        for (Object detachedElement : detachedElements) {
            if (elementsWithoutId) {
                if (scoColl.contains(detachedElement)) continue;
                scoColl.add(detachedElement);
                updated = true;
                continue;
            }
            Object detachedElemId = api.getIdForObject(detachedElement);
            scoCollIter = scoColl.iterator();
            contained = false;
            while (scoCollIter.hasNext()) {
                Object scoCollElem = scoCollIter.next();
                Object scoCollElemId = api.getIdForObject(scoCollElem);
                if (scoCollElemId == null || !scoCollElemId.equals(detachedElemId)) continue;
                contained = true;
                break;
            }
            if (!contained) {
                scoColl.add(detachedElement);
                updated = true;
                continue;
            }
            ownerSM.getExecutionContext().attachObjectCopy(ownerSM, detachedElement, false);
        }
        return updated;
    }

    public static void attachCopyForCollection(DNStateManager ownerSM, Object[] detachedElements, Collection attached, boolean elementsWithoutIdentity) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (int i = 0; i < detachedElements.length; ++i) {
            if (api.isPersistable(detachedElements[i]) && api.isDetachable(detachedElements[i])) {
                attached.add(ownerSM.getExecutionContext().attachObjectCopy(ownerSM, detachedElements[i], elementsWithoutIdentity));
                continue;
            }
            attached.add(detachedElements[i]);
        }
    }

    public static void attachCopyForMap(DNStateManager ownerSM, Set detachedEntries, Map attached, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        Iterator iter = detachedEntries.iterator();
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val) && api.isDetachable(val)) {
                val = ownerSM.getExecutionContext().attachObjectCopy(ownerSM, val, valuesWithoutIdentity);
            }
            if (api.isPersistable(key) && api.isDetachable(key)) {
                key = ownerSM.getExecutionContext().attachObjectCopy(ownerSM, key, keysWithoutIdentity);
            }
            attached.put(key, val);
        }
    }

    public static boolean updateCollectionWithCollection(ApiAdapter api, Collection coll, Collection elements) {
        boolean updated = false;
        Collection unwrapped = coll;
        if (coll instanceof SCO) {
            unwrapped = (Collection)((SCO)((Object)coll)).getValue();
        }
        HashSet unwrappedCopy = new HashSet(unwrapped);
        for (Object elem : elements) {
            if (api.isPersistable(elem) && !api.isPersistent(elem)) {
                coll.add(elem);
                updated = true;
                continue;
            }
            if (unwrapped.contains(elem)) continue;
            coll.add(elem);
            updated = true;
        }
        for (Object elem : unwrappedCopy) {
            if (elements.contains(elem)) continue;
            coll.remove(elem);
            updated = true;
        }
        return updated;
    }

    public static boolean updateListWithListElements(List list, List elements) {
        boolean updated = false;
        ArrayList newCopy = new ArrayList(elements);
        Iterator attachedIter = list.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (newCopy.remove(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        ArrayList oldCopy = new ArrayList(list);
        for (Object element : elements) {
            if (oldCopy.remove(element)) continue;
            list.add(element);
            updated = true;
        }
        Iterator elementsIter = elements.iterator();
        int position = 0;
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            Object currentElement = list.get(position);
            boolean updatePosition = false;
            if (element == null && currentElement != null || element != null && currentElement == null) {
                updatePosition = true;
            } else if (element != null && currentElement != null && !currentElement.equals(element)) {
                updatePosition = true;
            }
            if (updatePosition) {
                ((SCOList)((Object)list)).set(position, element, false);
                updated = true;
            }
            ++position;
        }
        return updated;
    }

    public static boolean updateMapWithMapKeysValues(ApiAdapter api, Map map, Map keysValues) {
        boolean updated = false;
        HashMap copy = new HashMap(map);
        for (Map.Entry entry : keysValues.entrySet()) {
            Object key = entry.getKey();
            if (api.isPersistable(key) && !api.isPersistent(key)) {
                map.put(key, keysValues.get(key));
                updated = true;
                continue;
            }
            if (!map.containsKey(key)) {
                map.put(key, keysValues.get(key));
                updated = true;
                continue;
            }
            Object value = entry.getValue();
            Object oldValue = map.get(key);
            if (api.isPersistable(value) && !api.isPersistent(value)) {
                map.put(key, value);
                continue;
            }
            if (api.isPersistable(value) && api.getIdForObject(value) != api.getIdForObject(oldValue)) {
                map.put(key, value);
                continue;
            }
            if ((oldValue != null || value == null) && (oldValue == null || oldValue.equals(value))) continue;
            map.put(key, value);
        }
        for (Map.Entry entry : copy.entrySet()) {
            Object key = entry.getKey();
            if (keysValues.containsKey(key)) continue;
            map.remove(key);
            updated = true;
        }
        return updated;
    }

    public static <K, V> void populateMapDelegateWithStoreData(Map<K, V> delegate, MapStore<K, V> store, DNStateManager ownerSM) {
        HashSet keys = new HashSet();
        if (!store.keysAreEmbedded() && !store.keysAreSerialised()) {
            SetStore<K> keystore = store.keySetStore();
            Iterator keyIter = keystore.iterator(ownerSM);
            while (keyIter.hasNext()) {
                keys.add(keyIter.next());
            }
        }
        ArrayList<V> values = new ArrayList<V>();
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised()) {
            CollectionStore<V> valuestore = store.valueCollectionStore();
            Iterator<V> valueIter = valuestore.iterator(ownerSM);
            while (valueIter.hasNext()) {
                values.add(valueIter.next());
            }
        }
        SetStore<Map.Entry<K, V>> entries = store.entrySetStore();
        Iterator entryIter = entries.iterator(ownerSM);
        while (entryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            delegate.put(key, value);
        }
        if (!store.keysAreEmbedded() && !store.keysAreSerialised() && delegate.size() != keys.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map key objects (" + keys.size() + ") was different to the number of entries (" + delegate.size() + "). Likely there is a bug in your datastore");
        }
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised() && delegate.size() != values.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map value objects (" + values.size() + ") was different to the number of entries (" + delegate.size() + "). Likely there is a bug in your datastore, or you have null values?");
        }
        keys.clear();
        values.clear();
    }

    public static Object[] toArray(CollectionStore backingStore, DNStateManager sm) {
        Object[] result = new Object[backingStore.size(sm)];
        Iterator it = backingStore.iterator(sm);
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    public static <T> T[] toArray(CollectionStore backingStore, DNStateManager sm, T[] a) {
        int size = backingStore.size(sm);
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = backingStore.iterator(sm);
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static Comparator getComparator(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        Comparator comparator = null;
        String comparatorName = null;
        if (mmd.hasMap()) {
            if (mmd.hasExtension("comparator-name")) {
                comparatorName = mmd.getValueForExtension("comparator-name");
            } else if (mmd.getMap().hasExtension("comparator-name")) {
                comparatorName = mmd.getMap().getValueForExtension("comparator-name");
            }
        } else if (mmd.hasCollection()) {
            if (mmd.hasExtension("comparator-name")) {
                comparatorName = mmd.getValueForExtension("comparator-name");
            } else if (mmd.getCollection().hasExtension("comparator-name")) {
                comparatorName = mmd.getCollection().getValueForExtension("comparator-name");
            }
        }
        if (comparatorName != null) {
            Class comparatorCls = null;
            try {
                comparatorCls = clr.classForName(comparatorName);
                comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("023012", mmd.getFullFieldName(), comparatorName));
            }
        }
        return comparator;
    }

    public static void detachCopyForCollection(ExecutionContext ec, Object[] elements, FetchPlanState state, Collection detached) {
        ApiAdapter api = ec.getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                detached.add(null);
                continue;
            }
            Object object = elements[i];
            if (api.isPersistable(object)) {
                detached.add(ec.detachObjectCopy(state, object));
                continue;
            }
            detached.add(object);
        }
    }

    public static void attachForCollection(DNStateManager ownerSM, Object[] elements, boolean elementsWithoutIdentity) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            Object attached;
            if (!api.isPersistable(elements[i]) || (attached = ec.getAttachedObjectForId(api.getIdForObject(elements[i]))) != null) continue;
            ec.attachObject(ownerSM, elements[i], elementsWithoutIdentity);
        }
    }

    public static void detachCopyForMap(ExecutionContext ec, Set entries, FetchPlanState state, Map detached) {
        ApiAdapter api = ec.getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val)) {
                val = ec.detachObjectCopy(state, val);
            }
            if (api.isPersistable(key)) {
                key = ec.detachObjectCopy(state, key);
            }
            detached.put(key, val);
        }
    }

    public static void attachForMap(DNStateManager ownerSM, Set entries, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (Map.Entry entry : entries) {
            Object attached;
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key) && (attached = ec.getAttachedObjectForId(api.getIdForObject(key))) == null) {
                ec.attachObject(ownerSM, key, keysWithoutIdentity);
            }
            if (!api.isPersistable(val) || (attached = ec.getAttachedObjectForId(api.getIdForObject(val))) != null) continue;
            ec.attachObject(ownerSM, val, valuesWithoutIdentity);
        }
    }

    public static boolean validateObjectForWriting(ExecutionContext ec, Object object, FieldValues fieldValues) {
        boolean persisted = false;
        ApiAdapter api = ec.getApiAdapter();
        if (api.isPersistable(object)) {
            ExecutionContext objectEC = api.getExecutionContext(object);
            if (objectEC != null && ec != objectEC) {
                throw new NucleusUserException(Localiser.msg("023009", StringUtils.toJVMIDString(object)), api.getIdForObject(object));
            }
            if (!api.isPersistent(object)) {
                boolean exists = false;
                if (api.isDetached(object)) {
                    if (ec.getBooleanProperty(PropertyNames.PROPERTY_ATTACH_SAME_DATASTORE).booleanValue()) {
                        exists = true;
                    } else {
                        try {
                            DNStateManager objSM;
                            Persistable obj = ec.findObject(api.getIdForObject(object), true, false, object.getClass().getName());
                            if (obj != null && (objSM = ec.findStateManager(obj)) != null) {
                                ec.evictFromTransaction(objSM);
                            }
                            exists = true;
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            exists = false;
                        }
                    }
                }
                if (!exists) {
                    ec.persistObjectInternal(object, fieldValues, PersistableObjectType.PC);
                    persisted = true;
                }
            } else {
                DNStateManager objectSM = ec.findStateManager(object);
                if (objectSM.isWaitingToBeFlushedToDatastore()) {
                    if (fieldValues != null) {
                        objectSM.loadFieldValues(fieldValues);
                    }
                    objectSM.flush();
                    persisted = true;
                }
            }
        }
        return persisted;
    }

    public static boolean isListBased(Class type) {
        if (type == null) {
            return false;
        }
        if (List.class.isAssignableFrom(type)) {
            return true;
        }
        return Queue.class.isAssignableFrom(type);
    }

    public static Class getContainerInstanceType(Class declaredType, Boolean ordered) {
        if (declaredType.isInterface()) {
            if (SortedSet.class.isAssignableFrom(declaredType)) {
                return TreeSet.class;
            }
            if (SortedMap.class.isAssignableFrom(declaredType)) {
                return TreeMap.class;
            }
            if (List.class.isAssignableFrom(declaredType)) {
                return ArrayList.class;
            }
            if (Set.class.isAssignableFrom(declaredType)) {
                return HashSet.class;
            }
            if (Map.class.isAssignableFrom(declaredType)) {
                return HashMap.class;
            }
            if (ordered.booleanValue()) {
                return ArrayList.class;
            }
            return HashSet.class;
        }
        return declaredType;
    }

    public static boolean detachAsWrapped(ExecutionContext ec) {
        return ec.getBooleanProperty(PropertyNames.PROPERTY_DETACH_AS_WRAPPED);
    }

    public static boolean useQueuedUpdate(DNStateManager sm) {
        return sm != null && sm.getExecutionContext().operationQueueIsActive();
    }

    public static boolean hasDependentElement(AbstractMemberMetaData mmd) {
        return !SCOUtils.collectionHasElementsWithoutIdentity(mmd) && mmd.getCollection() != null && mmd.getCollection().isDependentElement();
    }

    public static boolean hasDependentKey(AbstractMemberMetaData mmd) {
        return !SCOUtils.mapHasKeysWithoutIdentity(mmd) && mmd.getMap() != null && mmd.getMap().isDependentKey();
    }

    public static boolean hasDependentValue(AbstractMemberMetaData mmd) {
        return !SCOUtils.mapHasValuesWithoutIdentity(mmd) && mmd.getMap() != null && mmd.getMap().isDependentValue();
    }

    public static boolean collectionsAreEqual(ApiAdapter api, Collection oldColl, Collection newColl) {
        if (oldColl == null && newColl == null) {
            return true;
        }
        if (oldColl == null || newColl == null) {
            return false;
        }
        if (oldColl.size() != newColl.size()) {
            return false;
        }
        Iterator oldIter = oldColl.iterator();
        Iterator newIter = newColl.iterator();
        while (oldIter.hasNext()) {
            Object oldVal = oldIter.next();
            Object newVal = newIter.next();
            if (oldVal == null && newVal == null) continue;
            if (oldVal == null || newVal == null) {
                return false;
            }
            if (api.isPersistable(oldVal)) {
                Object oldId = api.getIdForObject(oldVal);
                Object newId = api.getIdForObject(newVal);
                if (oldId == null || newId == null) {
                    return false;
                }
                if (oldId.equals(newId)) continue;
                return false;
            }
            if (oldVal.equals(newVal)) continue;
            return false;
        }
        return true;
    }

    public static Object copyValue(Object scoValue) {
        if (scoValue == null) {
            return null;
        }
        if (scoValue instanceof StringBuffer) {
            return new StringBuffer(((StringBuffer)scoValue).toString());
        }
        if (scoValue instanceof StringBuilder) {
            return new StringBuilder(((StringBuilder)scoValue).toString());
        }
        if (scoValue instanceof Date) {
            return ((Date)scoValue).clone();
        }
        if (scoValue instanceof Calendar) {
            return ((Calendar)scoValue).clone();
        }
        return scoValue;
    }

    public static Object singleCollectionValue(TypeManager typeManager, Object pc) {
        if (pc == null) {
            return null;
        }
        Iterator iterator = typeManager.getContainerAdapter(pc).iterator();
        pc = iterator.hasNext() ? iterator.next() : null;
        return pc;
    }
}

