/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.ElementContainerHandler;
import org.datanucleus.store.types.containers.MapContainerAdapter;
import org.datanucleus.store.types.containers.SequenceAdapter;

public class PersistFieldManager
extends AbstractFieldManager {
    private final DNStateManager sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(DNStateManager sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected Object processPersistable(Object pc, int ownerFieldNum, PersistableObjectType objectType) {
        ApiAdapter adapter = this.sm.getExecutionContext().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            if (objectType != PersistableObjectType.PC) {
                return this.sm.getExecutionContext().persistObjectInternal(pc, null, objectType, this.sm, ownerFieldNum);
            }
            return this.sm.getExecutionContext().persistObjectInternal(pc, null, objectType);
        }
        return pc;
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        if (value != null) {
            ClassLoaderResolver clr;
            RelationType relationType;
            boolean[] secondClassMutableFieldFlags;
            AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                value = SCOUtils.wrapSCOField(this.sm, fieldNumber, value, true);
            }
            if (mmd.isCascadePersist() && (relationType = mmd.getRelationType(clr = this.sm.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
                if (mmd.hasContainer()) {
                    this.processContainer(value, mmd);
                } else if (mmd.isEmbedded() || mmd.isSerialized()) {
                    this.processPersistable(value, fieldNumber, PersistableObjectType.EMBEDDED_PC);
                } else {
                    this.processPersistable(value, -1, PersistableObjectType.PC);
                }
            }
        }
    }

    private void processContainer(Object container, AbstractMemberMetaData mmd) {
        if (mmd.hasMap()) {
            this.processMapContainer(mmd, container);
        } else {
            this.processElementContainer(mmd, container);
        }
    }

    private void processMapContainer(AbstractMemberMetaData mmd, Object container) {
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        MapContainerAdapter mapAdapter = (MapContainerAdapter)containerHandler.getAdapter((Object)container);
        for (Map.Entry<Object, Object> entry : mapAdapter.entries()) {
            DNStateManager valSM;
            DNStateManager keySM;
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            Object newMapKey = mapKey;
            Object newMapValue = mapValue;
            if (api.isPersistable(mapKey)) {
                PersistableObjectType mapKeyObjectType = mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedKey() ? PersistableObjectType.EMBEDDED_MAP_KEY_PC : PersistableObjectType.PC;
                newMapKey = this.processPersistable(mapKey, mmd.getAbsoluteFieldNumber(), mapKeyObjectType);
            }
            if (api.isPersistable(mapValue)) {
                PersistableObjectType mapValueObjectType = mmd.getMap().isEmbeddedValue() || mmd.getMap().isSerializedValue() ? PersistableObjectType.EMBEDDED_MAP_VALUE_PC : PersistableObjectType.PC;
                newMapValue = this.processPersistable(mapValue, mmd.getAbsoluteFieldNumber(), mapValueObjectType);
            }
            if (newMapKey == mapKey && newMapValue == mapValue) continue;
            boolean updateKey = false;
            boolean updateValue = false;
            if (newMapKey != mapKey && (keySM = this.sm.getExecutionContext().findStateManager(newMapKey)).getReferencedPC() != null) {
                updateKey = true;
            }
            if (newMapValue != mapValue && (valSM = this.sm.getExecutionContext().findStateManager(newMapValue)).getReferencedPC() != null) {
                updateValue = true;
            }
            if (updateKey) {
                mapAdapter.remove(mapKey);
                mapAdapter.put(newMapKey, updateValue ? newMapValue : mapValue);
                continue;
            }
            if (!updateValue) continue;
            mapAdapter.put(mapKey, newMapValue);
        }
    }

    private void processElementContainer(AbstractMemberMetaData mmd, Object container) {
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        ElementContainerHandler elementContainerHandler = (ElementContainerHandler)typeManager.getContainerHandler(mmd.getType());
        ElementContainerAdapter containerAdapter = (ElementContainerAdapter)elementContainerHandler.getAdapter(container);
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        PersistableObjectType objectType = elementContainerHandler.getObjectType(mmd);
        if (objectType == PersistableObjectType.PC) {
            int elementPosition = 0;
            for (Object element : containerAdapter) {
                if (api.isPersistable(element)) {
                    Object newElement = this.processPersistable(element, -1, objectType);
                    DNStateManager elementSM = this.sm.getExecutionContext().findStateManager(newElement);
                    if (elementSM.getReferencedPC() != null) {
                        if (containerAdapter instanceof SequenceAdapter) {
                            ((SequenceAdapter)((Object)containerAdapter)).update(newElement, elementPosition);
                        } else {
                            containerAdapter.remove(elementSM);
                            containerAdapter.add(newElement);
                        }
                    }
                }
                ++elementPosition;
            }
        } else {
            for (Object element : containerAdapter) {
                if (!api.isPersistable(element)) continue;
                this.processPersistable(element, mmd.getAbsoluteFieldNumber(), objectType);
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

