/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class CachedPC
implements Serializable,
Comparable<CachedPC> {
    private static final long serialVersionUID = 1326244752228266953L;
    private Class cls;
    private Object id;
    private Map<Integer, Object> fieldValues = null;
    private Object version;
    private boolean[] loadedFields;

    public CachedPC(Class cls, boolean[] loadedFields, Object vers, Object id) {
        this.cls = cls;
        this.id = id;
        this.loadedFields = new boolean[loadedFields.length];
        for (int i = 0; i < loadedFields.length; ++i) {
            this.loadedFields[i] = loadedFields[i];
        }
        this.version = vers;
    }

    public Class getObjectClass() {
        return this.cls;
    }

    public Object getId() {
        return this.id;
    }

    public void setFieldValue(Integer fieldNumber, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new HashMap<Integer, Object>();
        }
        this.fieldValues.put(fieldNumber, value);
    }

    public Object getFieldValue(Integer fieldNumber) {
        return this.fieldValues == null ? null : this.fieldValues.get(fieldNumber);
    }

    public void setVersion(Object ver) {
        this.version = ver;
    }

    public Object getVersion() {
        return this.version;
    }

    public boolean[] getLoadedFields() {
        return this.loadedFields;
    }

    public int[] getLoadedFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.loadedFields, true);
    }

    public void setLoadedField(int fieldNumber, boolean loaded) {
        this.loadedFields[fieldNumber] = loaded;
    }

    public synchronized CachedPC getCopy() {
        CachedPC copy = new CachedPC(this.cls, this.loadedFields, this.version, this.id);
        if (this.fieldValues != null) {
            copy.fieldValues = new HashMap<Integer, Object>(this.fieldValues.size());
            for (Map.Entry<Integer, Object> entry : this.fieldValues.entrySet()) {
                Integer key = entry.getKey();
                Object val = entry.getValue();
                if (val != null && val instanceof CachedPC) {
                    val = ((CachedPC)val).getCopy();
                }
                copy.fieldValues.put(key, val);
            }
        }
        return copy;
    }

    @Override
    public int compareTo(CachedPC other) {
        if (other == null) {
            return -1;
        }
        if (this.id == null) {
            return -1;
        }
        if (this.cls.getName().equals(other.cls.getName())) {
            return this.id.toString().compareTo(other.id.toString());
        }
        return this.cls.getName().compareTo(other.cls.getName());
    }

    public String toString() {
        return this.toString("", false);
    }

    public String toString(String indent, boolean debug) {
        StringBuilder str = new StringBuilder();
        str.append(indent).append("CachedPC : cls=").append(this.cls.getName()).append(" version=").append(this.version).append(" loadedFlags=").append(StringUtils.booleanArrayToString(this.loadedFields));
        if (debug && this.fieldValues != null) {
            str.append(" numValues=").append(this.fieldValues.size()).append("\n");
            Iterator<Map.Entry<Integer, Object>> fieldValuesIter = this.fieldValues.entrySet().iterator();
            while (fieldValuesIter.hasNext()) {
                Map.Entry<Integer, Object> fieldValuesEntry = fieldValuesIter.next();
                str.append(indent).append("  ").append("field=").append(fieldValuesEntry.getKey()).append(" value=");
                if (fieldValuesEntry.getValue() instanceof CachedPC) {
                    str.append("\n");
                    str.append(((CachedPC)fieldValuesEntry.getValue()).toString(indent + "  ", debug));
                } else {
                    str.append(fieldValuesEntry.getValue());
                    if (fieldValuesEntry.getValue() != null) {
                        str.append(" type=" + fieldValuesEntry.getValue().getClass().getName());
                    }
                }
                if (!fieldValuesIter.hasNext()) continue;
                str.append("\n");
            }
        }
        return str.toString();
    }

    public static class CachedId
    implements Serializable,
    Comparable<CachedId> {
        private static final long serialVersionUID = -2806783207184913323L;
        String className;
        Object id;

        public CachedId(String className, Object id) {
            this.className = className;
            this.id = id;
        }

        public String getClassName() {
            return this.className;
        }

        public Object getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CachedId)) {
                return false;
            }
            CachedId other = (CachedId)obj;
            return other.className.equals(this.className) && other.id.equals(this.id);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.id.hashCode();
        }

        @Override
        public int compareTo(CachedId obj) {
            if (obj == null) {
                return 1;
            }
            return this.hashCode() - obj.hashCode();
        }
    }
}

