/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;

public class TxnCommonUtils {
    public static ValidTxnList createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        assert (currentTxn <= txns.getTxn_high_water_mark());
        long highWaterMark = currentTxn > 0L ? Math.min(currentTxn, txns.getTxn_high_water_mark()) : txns.getTxn_high_water_mark();
        List<Long> openTxns = txns.getOpen_txns();
        int sizeToHwm = currentTxn > 0L ? Math.abs(Collections.binarySearch(openTxns, currentTxn)) : openTxns.size();
        sizeToHwm = Math.min(sizeToHwm, openTxns.size());
        long[] exceptions = new long[sizeToHwm];
        BitSet inAbortedBits = BitSet.valueOf(txns.getAbortedBits());
        BitSet outAbortedBits = new BitSet();
        long minOpenTxnId = Long.MAX_VALUE;
        int i = 0;
        for (long txn : openTxns) {
            if (currentTxn > 0L && txn >= currentTxn) break;
            if (inAbortedBits.get(i)) {
                outAbortedBits.set(i);
            } else if (minOpenTxnId == Long.MAX_VALUE) {
                minOpenTxnId = txn;
            }
            exceptions[i++] = txn;
        }
        return new ValidReadTxnList(exceptions, outAbortedBits, highWaterMark, minOpenTxnId);
    }

    public static ValidTxnWriteIdList createValidTxnWriteIdList(Long currentTxnId, List<TableValidWriteIds> validIds) {
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(currentTxnId);
        for (TableValidWriteIds tableWriteIds : validIds) {
            validTxnWriteIdList.addTableValidWriteIdList((ValidWriteIdList)TxnCommonUtils.createValidReaderWriteIdList(tableWriteIds));
        }
        return validTxnWriteIdList;
    }

    public static ValidReaderWriteIdList createValidReaderWriteIdList(TableValidWriteIds tableWriteIds) {
        String fullTableName = tableWriteIds.getFullTableName();
        long highWater = tableWriteIds.getWriteIdHighWaterMark();
        List<Long> invalids = tableWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        for (long writeId : invalids) {
            exceptions[i++] = writeId;
        }
        if (tableWriteIds.isSetMinOpenWriteId()) {
            return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater, tableWriteIds.getMinOpenWriteId());
        }
        return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater);
    }
}

